/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter.scheduler;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import me.zhyd.hunter.config.HunterConfig;
import me.zhyd.hunter.enums.ExitWayEnum;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.DuplicateRemovedScheduler;
import us.codecraft.webmagic.scheduler.MonitorableScheduler;

public class BlockingQueueScheduler
extends DuplicateRemovedScheduler
implements MonitorableScheduler {
    private BlockingQueue<Request> queue = new LinkedBlockingQueue<Request>();
    private int realUrlCount = -1;

    public BlockingQueueScheduler(HunterConfig model) {
        if (ExitWayEnum.URL_COUNT.toString().equals(model.getExitWay())) {
            this.realUrlCount = model.getCount() + model.getEntryUrls().size();
        }
    }

    public void pushWhenNoDuplicate(Request request, Task task) {
        if (this.realUrlCount == -1) {
            this.queue.add(request);
            return;
        }
        if (this.realUrlCount <= 0) {
            return;
        }
        --this.realUrlCount;
        this.queue.add(request);
    }

    public Request poll(Task task) {
        return (Request)this.queue.poll();
    }

    public int getLeftRequestsCount(Task task) {
        return this.queue.size();
    }

    public int getTotalRequestsCount(Task task) {
        return this.getDuplicateRemover().getTotalRequestsCount(task);
    }
}

