/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter.config.platform;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import me.zhyd.hunter.config.HunterConfig;
import me.zhyd.hunter.config.HunterConfigTemplate;
import me.zhyd.hunter.config.platform.InnerPlatform;
import me.zhyd.hunter.config.platform.Platform;
import me.zhyd.hunter.util.PlatformUtil;

public abstract class BasePlatform
implements InnerPlatform {
    String platform;

    public BasePlatform(String platform) {
        this.platform = platform;
    }

    protected final HunterConfig get(String url) {
        String host = PlatformUtil.getHost(url);
        String domain = PlatformUtil.getDomain(url);
        String platformConfig = HunterConfigTemplate.getConfig(this.platform);
        JSONObject platformObj = JSONObject.parseObject((String)platformConfig);
        String br = "\r\n";
        String header = null;
        Set entries = platformObj.entrySet();
        for (Map.Entry entry : entries) {
            if ("header".equals(entry.getKey())) {
                header = "Host=" + host + br + "Referer=" + domain;
                entry.setValue(header);
                continue;
            }
            if ("entryUrls".equals(entry.getKey())) {
                entry.setValue(Collections.singletonList(url));
                continue;
            }
            if (!this.platform.equals(Platform.ITEYE.getPlatform()) || !"domain".equals(entry.getKey())) continue;
            entry.setValue(host);
        }
        HunterConfig config = (HunterConfig)JSONObject.toJavaObject((JSON)platformObj, HunterConfig.class);
        config.setSingle(true);
        return config;
    }
}

