/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.zhyd.hunter.config.HunterConfig;
import me.zhyd.hunter.config.HunterConfigTemplate;
import me.zhyd.hunter.config.platform.InnerPlatform;
import me.zhyd.hunter.config.platform.Platform;
import me.zhyd.hunter.util.PlatformUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class HunterConfigContext {
    public static HunterConfig getHunterConfig(String url) {
        InnerPlatform platform = PlatformUtil.getPlarform(url);
        return platform.process(url);
    }

    public static HunterConfig getHunterConfig(Platform platform) {
        String platformConfig = HunterConfigTemplate.getConfig(platform.getPlatform());
        JSONObject platformObj = JSONObject.parseObject((String)platformConfig);
        String br = "\r\n";
        Set entries = platformObj.entrySet();
        for (Map.Entry entry : entries) {
            if (!"header".equals(entry.getKey())) continue;
            List headers = JSONArray.parseArray((String)String.valueOf(entry.getValue()), String.class);
            entry.setValue(String.join((CharSequence)br, headers));
        }
        return (HunterConfig)JSONObject.toJavaObject((JSON)platformObj, HunterConfig.class);
    }

    public static HunterConfig parseConfig(HunterConfig config) {
        Map<String, String> header;
        List<String> entryUrls;
        String targetLinksRegex;
        if (null == config) {
            return null;
        }
        String uid = config.getUid();
        if (StringUtils.isEmpty((CharSequence)uid)) {
            return config;
        }
        String domain = config.getDomain();
        if (StringUtils.isNotEmpty((CharSequence)domain)) {
            config.setDomain(domain.replace("{uid}", uid));
        }
        if (StringUtils.isNotEmpty((CharSequence)(targetLinksRegex = config.getTargetLinksRegex()))) {
            config.setTargetLinksRegex(targetLinksRegex.replace("{uid}", uid));
        }
        if (CollectionUtils.isNotEmpty(entryUrls = config.getEntryUrls())) {
            ArrayList<String> newEntryUrls = new ArrayList<String>();
            for (String entryUrl : entryUrls) {
                newEntryUrls.add(entryUrl.replace("{uid}", uid));
            }
            config.setEntryUrls(newEntryUrls);
        }
        if (MapUtils.isNotEmpty(header = config.getHeaders())) {
            Set<Map.Entry<String, String>> entries = header.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String key = entry.getKey();
                String value = entry.getValue();
                header.put(key, value.replace("{uid}", uid));
            }
        }
        return config;
    }
}

