/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import me.zhyd.hunter.entity.Cookie;
import me.zhyd.hunter.enums.ExitWayEnum;
import me.zhyd.hunter.enums.UserAgentEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import us.codecraft.webmagic.proxy.Proxy;

public class HunterConfig {
    public boolean single;
    @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u6807\u9898\u6293\u53d6\u89c4\u5219(xpath)")
    private @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u6807\u9898\u6293\u53d6\u89c4\u5219(xpath)") String titleRegex;
    @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u5185\u5bb9\u6293\u53d6\u89c4\u5219(xpath)")
    private @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u5185\u5bb9\u6293\u53d6\u89c4\u5219(xpath)") String contentRegex;
    @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u53d1\u5e03\u65e5\u671f\u6293\u53d6\u89c4\u5219(xpath)")
    private @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u53d1\u5e03\u65e5\u671f\u6293\u53d6\u89c4\u5219(xpath)") String releaseDateRegex;
    @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u4f5c\u8005\u6293\u53d6\u89c4\u5219(xpath)")
    private @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u4f5c\u8005\u6293\u53d6\u89c4\u5219(xpath)") String authorRegex;
    @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u5f85\u6293\u53d6\u7684url\u6293\u53d6\u89c4\u5219(regex)")
    private @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u5f85\u6293\u53d6\u7684url\u6293\u53d6\u89c4\u5219(regex)") String targetLinksRegex;
    private String tagRegex;
    private String keywordsRegex = "//meta[@name=keywords]/@content";
    private String descriptionRegex = "//meta[@name=description]/@content";
    @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u7f51\u7ad9\u6839\u57df\u540d")
    private @NotNull(message="\u5fc5\u987b\u6307\u5b9a\u7f51\u7ad9\u6839\u57df\u540d") String domain;
    private String charset = "utf8";
    @Max(value=10000L, message="\u7ebf\u7a0b\u7b49\u5f85\u65f6\u95f4\u4e0d\u53ef\u5927\u4e8e10000\u6beb\u79d2")
    @Min(value=100L, message="\u7ebf\u7a0b\u7b49\u5f85\u65f6\u95f4\u4e0d\u53ef\u5c0f\u4e8e100\u6beb\u79d2")
    private @Max(value=10000L, message="\u7ebf\u7a0b\u7b49\u5f85\u65f6\u95f4\u4e0d\u53ef\u5927\u4e8e10000\u6beb\u79d2") @Min(value=100L, message="\u7ebf\u7a0b\u7b49\u5f85\u65f6\u95f4\u4e0d\u53ef\u5c0f\u4e8e100\u6beb\u79d2") int sleepTime = 1000;
    @Max(value=5L, message="\u6293\u53d6\u5931\u8d25\u65f6\u6700\u591a\u53ea\u80fd\u91cd\u8bd55\u6b21")
    @Min(value=1L, message="\u6293\u53d6\u5931\u8d25\u65f6\u6700\u5c11\u53ea\u80fd\u91cd\u8bd51\u6b21")
    private @Max(value=5L, message="\u6293\u53d6\u5931\u8d25\u65f6\u6700\u591a\u53ea\u80fd\u91cd\u8bd55\u6b21") @Min(value=1L, message="\u6293\u53d6\u5931\u8d25\u65f6\u6700\u5c11\u53ea\u80fd\u91cd\u8bd51\u6b21") int retryTimes = 2;
    @Max(value=5L, message="\u6700\u591a\u652f\u63015\u6b21\u5931\u8d25\u5faa\u73af\u91cd\u8bd5")
    @Min(value=1L, message="\u6700\u5c11\u652f\u63011\u6b21\u5931\u8d25\u5faa\u73af\u91cd\u8bd5")
    private @Max(value=5L, message="\u6700\u591a\u652f\u63015\u6b21\u5931\u8d25\u5faa\u73af\u91cd\u8bd5") @Min(value=1L, message="\u6700\u5c11\u652f\u63011\u6b21\u5931\u8d25\u5faa\u73af\u91cd\u8bd5") int cycleRetryTimes = 2;
    @Max(value=10L, message="\u6700\u591a\u53ea\u80fd\u5f00\u542f10\u4e2a\u7ebf\u7a0b\uff08\u8bf7\u8c28\u614e\u4f7f\u7528\uff09")
    @Min(value=1L, message="\u81f3\u5c11\u8981\u5f00\u542f1\u4e2a\u7ebf\u7a0b")
    private @Max(value=10L, message="\u6700\u591a\u53ea\u80fd\u5f00\u542f10\u4e2a\u7ebf\u7a0b\uff08\u8bf7\u8c28\u614e\u4f7f\u7528\uff09") @Min(value=1L, message="\u81f3\u5c11\u8981\u5f00\u542f1\u4e2a\u7ebf\u7a0b") int threadCount = 1;
    private List<String> entryUrls;
    private String exitWay = ExitWayEnum.URL_COUNT.toString();
    private int count;
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private Map<String, String> headers = new HashMap<String, String>();
    private String ua = UserAgentEnum.getRandomUa();
    private String uid;
    private boolean onlyThisAuthor;
    private Boolean ajaxRequest = false;
    private boolean convertImg = false;
    private List<Proxy> proxyList = new ArrayList<Proxy>();
    private ProxyType proxyType = ProxyType.CUSTOM;

    public HunterConfig setUid(String uid) {
        this.uid = uid;
        return this;
    }

    public HunterConfig setOnlyThisAuthor(boolean onlyThisAuthor) {
        this.onlyThisAuthor = onlyThisAuthor;
        return this;
    }

    public HunterConfig setTitleRegex(String titleRegex) {
        this.titleRegex = titleRegex;
        return this;
    }

    public HunterConfig setContentRegex(String contentRegex) {
        this.contentRegex = contentRegex;
        return this;
    }

    public HunterConfig setReleaseDateRegex(String releaseDateRegex) {
        this.releaseDateRegex = releaseDateRegex;
        return this;
    }

    public HunterConfig setAuthorRegex(String authorRegex) {
        this.authorRegex = authorRegex;
        return this;
    }

    public HunterConfig setTargetLinksRegex(String targetLinksRegex) {
        this.targetLinksRegex = targetLinksRegex;
        return this;
    }

    public HunterConfig setTagRegex(String tagRegex) {
        this.tagRegex = tagRegex;
        return this;
    }

    public HunterConfig setKeywordsRegex(String keywordsRegex) {
        this.keywordsRegex = keywordsRegex;
        return this;
    }

    public HunterConfig setDescriptionRegex(String descriptionRegex) {
        this.descriptionRegex = descriptionRegex;
        return this;
    }

    public HunterConfig setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public HunterConfig setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public HunterConfig setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
        return this;
    }

    public HunterConfig setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        return this;
    }

    public HunterConfig setCycleRetryTimes(int cycleRetryTimes) {
        this.cycleRetryTimes = cycleRetryTimes;
        return this;
    }

    public HunterConfig setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public HunterConfig setEntryUrls(List<String> entryUrls) {
        this.entryUrls = entryUrls;
        return this;
    }

    public HunterConfig setEntryUrls(String entryUrls) {
        if (StringUtils.isNotEmpty((CharSequence)entryUrls)) {
            if (entryUrls.startsWith("[")) {
                entryUrls = entryUrls.substring(1);
            }
            if (entryUrls.endsWith("]")) {
                entryUrls = entryUrls.substring(0, entryUrls.length() - 1);
            }
            List<String> list = Arrays.asList(entryUrls.split("\r\n"));
            this.entryUrls = new LinkedList<String>();
            this.entryUrls.addAll(list);
        }
        return this;
    }

    public HunterConfig addEntryUrl(String url) {
        if (CollectionUtils.isEmpty(this.entryUrls)) {
            this.entryUrls = new LinkedList<String>();
        }
        this.entryUrls.add(url);
        return this;
    }

    public HunterConfig setExitWay(String exitWay) {
        this.exitWay = exitWay;
        return this;
    }

    public HunterConfig setExitWay(ExitWayEnum exitWay) {
        this.exitWay = exitWay.toString();
        this.count = exitWay.getDefaultCount();
        return this;
    }

    public HunterConfig setCount(int count) {
        this.count = count;
        return this;
    }

    public HunterConfig setHeader(String key, String value) {
        Map<String, String> headers = this.getHeaders();
        headers.put(key, value);
        return this;
    }

    public HunterConfig setHeader(String headersStr) {
        if (StringUtils.isNotEmpty((CharSequence)headersStr)) {
            String[] headerArr;
            for (String s : headerArr = headersStr.split("\r\n")) {
                String[] header = s.split("=");
                this.setHeader(header[0], header[1]);
            }
        }
        return this;
    }

    public HunterConfig setCookie(String domain, String key, String value) {
        List<Cookie> cookies = this.getCookies();
        cookies.add(new Cookie(domain, key, value));
        return this;
    }

    public HunterConfig setCookie(String cookiesStr) {
        if (StringUtils.isNotEmpty((CharSequence)cookiesStr)) {
            String[] cookieArr;
            List<Cookie> cookies = this.getCookies();
            for (String aCookieArr : cookieArr = cookiesStr.split(";")) {
                String[] cookieNode = aCookieArr.split("=");
                if (cookieNode.length <= 1) continue;
                cookies.add(new Cookie(cookieNode[0].trim(), cookieNode[1].trim()));
            }
        }
        return this;
    }

    public HunterConfig setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
        return this;
    }

    private void addProxy(Proxy proxy) {
        if (this.proxyType == ProxyType.CUSTOM || null == proxy) {
            return;
        }
        this.proxyList.add(proxy);
    }

    public HunterConfig setProxy(String proxyStr) {
        String[] proxyArr;
        if (this.proxyType != ProxyType.CUSTOM || proxyStr == null) {
            return this;
        }
        for (String s : proxyArr = proxyStr.split("\r\n")) {
            String[] proxy = s.split("|");
            if (proxy.length == 2) {
                this.addProxy(new Proxy(proxy[0], Integer.parseInt(proxy[1])));
                continue;
            }
            if (proxy.length != 4) continue;
            this.addProxy(new Proxy(proxy[0], Integer.parseInt(proxy[1]), proxy[2], proxy[3]));
        }
        return this;
    }

    public HunterConfig setConvertImg(boolean convertImg) {
        this.convertImg = convertImg;
        return this;
    }

    public HunterConfig setSingle(boolean single) {
        this.single = single;
        return this;
    }

    public boolean isSingle() {
        return this.single;
    }

    public String getTitleRegex() {
        return this.titleRegex;
    }

    public String getContentRegex() {
        return this.contentRegex;
    }

    public String getReleaseDateRegex() {
        return this.releaseDateRegex;
    }

    public String getAuthorRegex() {
        return this.authorRegex;
    }

    public String getTargetLinksRegex() {
        return this.targetLinksRegex;
    }

    public String getTagRegex() {
        return this.tagRegex;
    }

    public String getKeywordsRegex() {
        return this.keywordsRegex;
    }

    public String getDescriptionRegex() {
        return this.descriptionRegex;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public int getCycleRetryTimes() {
        return this.cycleRetryTimes;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public List<String> getEntryUrls() {
        return this.entryUrls;
    }

    public String getExitWay() {
        return this.exitWay;
    }

    public int getCount() {
        return this.count;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getUa() {
        return this.ua;
    }

    public String getUid() {
        return this.uid;
    }

    public boolean isOnlyThisAuthor() {
        return this.onlyThisAuthor;
    }

    public Boolean getAjaxRequest() {
        return this.ajaxRequest;
    }

    public boolean isConvertImg() {
        return this.convertImg;
    }

    public List<Proxy> getProxyList() {
        return this.proxyList;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public void setProxyList(List<Proxy> proxyList) {
        this.proxyList = proxyList;
    }

    public void setProxyType(ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HunterConfig)) {
            return false;
        }
        HunterConfig other = (HunterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSingle() != other.isSingle()) {
            return false;
        }
        String this$titleRegex = this.getTitleRegex();
        String other$titleRegex = other.getTitleRegex();
        if (this$titleRegex == null ? other$titleRegex != null : !this$titleRegex.equals(other$titleRegex)) {
            return false;
        }
        String this$contentRegex = this.getContentRegex();
        String other$contentRegex = other.getContentRegex();
        if (this$contentRegex == null ? other$contentRegex != null : !this$contentRegex.equals(other$contentRegex)) {
            return false;
        }
        String this$releaseDateRegex = this.getReleaseDateRegex();
        String other$releaseDateRegex = other.getReleaseDateRegex();
        if (this$releaseDateRegex == null ? other$releaseDateRegex != null : !this$releaseDateRegex.equals(other$releaseDateRegex)) {
            return false;
        }
        String this$authorRegex = this.getAuthorRegex();
        String other$authorRegex = other.getAuthorRegex();
        if (this$authorRegex == null ? other$authorRegex != null : !this$authorRegex.equals(other$authorRegex)) {
            return false;
        }
        String this$targetLinksRegex = this.getTargetLinksRegex();
        String other$targetLinksRegex = other.getTargetLinksRegex();
        if (this$targetLinksRegex == null ? other$targetLinksRegex != null : !this$targetLinksRegex.equals(other$targetLinksRegex)) {
            return false;
        }
        String this$tagRegex = this.getTagRegex();
        String other$tagRegex = other.getTagRegex();
        if (this$tagRegex == null ? other$tagRegex != null : !this$tagRegex.equals(other$tagRegex)) {
            return false;
        }
        String this$keywordsRegex = this.getKeywordsRegex();
        String other$keywordsRegex = other.getKeywordsRegex();
        if (this$keywordsRegex == null ? other$keywordsRegex != null : !this$keywordsRegex.equals(other$keywordsRegex)) {
            return false;
        }
        String this$descriptionRegex = this.getDescriptionRegex();
        String other$descriptionRegex = other.getDescriptionRegex();
        if (this$descriptionRegex == null ? other$descriptionRegex != null : !this$descriptionRegex.equals(other$descriptionRegex)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        if (this.getSleepTime() != other.getSleepTime()) {
            return false;
        }
        if (this.getRetryTimes() != other.getRetryTimes()) {
            return false;
        }
        if (this.getCycleRetryTimes() != other.getCycleRetryTimes()) {
            return false;
        }
        if (this.getThreadCount() != other.getThreadCount()) {
            return false;
        }
        List<String> this$entryUrls = this.getEntryUrls();
        List<String> other$entryUrls = other.getEntryUrls();
        if (this$entryUrls == null ? other$entryUrls != null : !((Object)this$entryUrls).equals(other$entryUrls)) {
            return false;
        }
        String this$exitWay = this.getExitWay();
        String other$exitWay = other.getExitWay();
        if (this$exitWay == null ? other$exitWay != null : !this$exitWay.equals(other$exitWay)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        List<Cookie> this$cookies = this.getCookies();
        List<Cookie> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$ua = this.getUa();
        String other$ua = other.getUa();
        if (this$ua == null ? other$ua != null : !this$ua.equals(other$ua)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        if (this.isOnlyThisAuthor() != other.isOnlyThisAuthor()) {
            return false;
        }
        Boolean this$ajaxRequest = this.getAjaxRequest();
        Boolean other$ajaxRequest = other.getAjaxRequest();
        if (this$ajaxRequest == null ? other$ajaxRequest != null : !((Object)this$ajaxRequest).equals(other$ajaxRequest)) {
            return false;
        }
        if (this.isConvertImg() != other.isConvertImg()) {
            return false;
        }
        List<Proxy> this$proxyList = this.getProxyList();
        List<Proxy> other$proxyList = other.getProxyList();
        if (this$proxyList == null ? other$proxyList != null : !((Object)this$proxyList).equals(other$proxyList)) {
            return false;
        }
        ProxyType this$proxyType = this.getProxyType();
        ProxyType other$proxyType = other.getProxyType();
        return !(this$proxyType == null ? other$proxyType != null : !((Object)((Object)this$proxyType)).equals((Object)other$proxyType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HunterConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSingle() ? 79 : 97);
        String $titleRegex = this.getTitleRegex();
        result = result * 59 + ($titleRegex == null ? 43 : $titleRegex.hashCode());
        String $contentRegex = this.getContentRegex();
        result = result * 59 + ($contentRegex == null ? 43 : $contentRegex.hashCode());
        String $releaseDateRegex = this.getReleaseDateRegex();
        result = result * 59 + ($releaseDateRegex == null ? 43 : $releaseDateRegex.hashCode());
        String $authorRegex = this.getAuthorRegex();
        result = result * 59 + ($authorRegex == null ? 43 : $authorRegex.hashCode());
        String $targetLinksRegex = this.getTargetLinksRegex();
        result = result * 59 + ($targetLinksRegex == null ? 43 : $targetLinksRegex.hashCode());
        String $tagRegex = this.getTagRegex();
        result = result * 59 + ($tagRegex == null ? 43 : $tagRegex.hashCode());
        String $keywordsRegex = this.getKeywordsRegex();
        result = result * 59 + ($keywordsRegex == null ? 43 : $keywordsRegex.hashCode());
        String $descriptionRegex = this.getDescriptionRegex();
        result = result * 59 + ($descriptionRegex == null ? 43 : $descriptionRegex.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        result = result * 59 + this.getSleepTime();
        result = result * 59 + this.getRetryTimes();
        result = result * 59 + this.getCycleRetryTimes();
        result = result * 59 + this.getThreadCount();
        List<String> $entryUrls = this.getEntryUrls();
        result = result * 59 + ($entryUrls == null ? 43 : ((Object)$entryUrls).hashCode());
        String $exitWay = this.getExitWay();
        result = result * 59 + ($exitWay == null ? 43 : $exitWay.hashCode());
        result = result * 59 + this.getCount();
        List<Cookie> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $ua = this.getUa();
        result = result * 59 + ($ua == null ? 43 : $ua.hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        result = result * 59 + (this.isOnlyThisAuthor() ? 79 : 97);
        Boolean $ajaxRequest = this.getAjaxRequest();
        result = result * 59 + ($ajaxRequest == null ? 43 : ((Object)$ajaxRequest).hashCode());
        result = result * 59 + (this.isConvertImg() ? 79 : 97);
        List<Proxy> $proxyList = this.getProxyList();
        result = result * 59 + ($proxyList == null ? 43 : ((Object)$proxyList).hashCode());
        ProxyType $proxyType = this.getProxyType();
        result = result * 59 + ($proxyType == null ? 43 : ((Object)((Object)$proxyType)).hashCode());
        return result;
    }

    public String toString() {
        return "HunterConfig(single=" + this.isSingle() + ", titleRegex=" + this.getTitleRegex() + ", contentRegex=" + this.getContentRegex() + ", releaseDateRegex=" + this.getReleaseDateRegex() + ", authorRegex=" + this.getAuthorRegex() + ", targetLinksRegex=" + this.getTargetLinksRegex() + ", tagRegex=" + this.getTagRegex() + ", keywordsRegex=" + this.getKeywordsRegex() + ", descriptionRegex=" + this.getDescriptionRegex() + ", domain=" + this.getDomain() + ", charset=" + this.getCharset() + ", sleepTime=" + this.getSleepTime() + ", retryTimes=" + this.getRetryTimes() + ", cycleRetryTimes=" + this.getCycleRetryTimes() + ", threadCount=" + this.getThreadCount() + ", entryUrls=" + this.getEntryUrls() + ", exitWay=" + this.getExitWay() + ", count=" + this.getCount() + ", cookies=" + this.getCookies() + ", headers=" + this.getHeaders() + ", ua=" + this.getUa() + ", uid=" + this.getUid() + ", onlyThisAuthor=" + this.isOnlyThisAuthor() + ", ajaxRequest=" + this.getAjaxRequest() + ", convertImg=" + this.isConvertImg() + ", proxyList=" + this.getProxyList() + ", proxyType=" + (Object)((Object)this.getProxyType()) + ")";
    }

    static enum ProxyType {
        AUTO,
        CUSTOM,
        DISABLE;

    }
}

