/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.braum.spring.boot.cache;

import java.util.concurrent.TimeUnit;
import me.zhyd.braum.spring.boot.cache.Cache;
import me.zhyd.braum.spring.boot.cache.CacheObj;
import me.zhyd.braum.spring.boot.property.BraumProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;

public class RedisCache
implements Cache {
    @Autowired
    RedisTemplate<String, CacheObj> redisTemplate;
    @Autowired
    BraumProperties properties;

    @Override
    public void set(String key, Integer value, long delay, TimeUnit unit) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        Assert.notNull((Object)value, (String)"The object argument [value] must be null");
        Assert.notNull((Object)((Object)unit), (String)"The object argument [unit] must be null");
        this.redisTemplate.opsForValue().set((Object)key, (Object)new CacheObj(value), delay, unit);
    }

    @Override
    public void set(String key, Integer value) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        Assert.notNull((Object)value, (String)"The object argument [value] must be null");
        ValueOperations operations = this.redisTemplate.opsForValue();
        CacheObj cacheObj = (CacheObj)operations.get((Object)key);
        if (null == cacheObj) {
            this.set(key, value, this.properties.getInterval(), TimeUnit.MILLISECONDS);
        } else {
            operations.set((Object)key, (Object)cacheObj.setValue(value), this.getExpire(key), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public CacheObj get(String key) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        return (CacheObj)this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public Boolean hasKey(String key) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public void del(String key) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        if (this.hasKey(key).booleanValue()) {
            this.redisTemplate.delete((Object)key);
        }
    }

    @Override
    public long getExpire(String key) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        return this.redisTemplate.getExpire((Object)key, TimeUnit.MILLISECONDS);
    }

    @Override
    public int incrementAndGet(String key) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        int value = 0;
        CacheObj obj = this.get(key);
        value = null == obj ? 1 : obj.getValue() + 1;
        this.set(key, value);
        return value;
    }
}

