/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.braum.spring.boot.cache;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import me.zhyd.braum.spring.boot.cache.Cache;
import me.zhyd.braum.spring.boot.cache.CacheObj;
import me.zhyd.braum.spring.boot.cache.CacheScheduler;
import me.zhyd.braum.spring.boot.property.BraumProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class ConcurrentHashMapCache
implements Cache {
    private static final Map<String, CacheObj> STORE = new ConcurrentHashMap<String, CacheObj>();
    private static final int DEFAULT_CLEAR_CACHE_DELAY = 5;
    private static final TimeUnit DEFAULT_CLEAR_CACHE_UNIT = TimeUnit.MINUTES;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Lock writeLock = this.lock.writeLock();
    private final Lock readLock = this.lock.readLock();
    @Autowired
    BraumProperties properties;

    public ConcurrentHashMapCache() {
        CacheScheduler.INSTANCE.schedule(this::clear, 5L, DEFAULT_CLEAR_CACHE_UNIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, Integer value, long delay, TimeUnit unit) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        Assert.notNull((Object)value, (String)"The object argument [value] must be null");
        Assert.notNull((Object)((Object)unit), (String)"The object argument [unit] must be null");
        this.writeLock.lock();
        try {
            STORE.put(key, new CacheObj(value, delay, unit));
            CacheScheduler.INSTANCE.schedule(() -> this.del(key), delay, unit);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, Integer value) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        Assert.notNull((Object)value, (String)"The object argument [value] must be null");
        this.writeLock.lock();
        long delay = this.properties.getInterval();
        TimeUnit unit = TimeUnit.MILLISECONDS;
        try {
            CacheObj cacheObj = STORE.get(key);
            if (null == cacheObj) {
                this.set(key, value, delay, unit);
            } else {
                cacheObj.setValue(value);
                STORE.put(key, cacheObj);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public CacheObj get(String key) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        this.readLock.lock();
        try {
            CacheObj cacheObj = STORE.get(key);
            return cacheObj;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Boolean hasKey(String key) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        this.readLock.lock();
        try {
            Boolean bl = STORE.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void del(String key) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        this.writeLock.lock();
        try {
            STORE.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getExpire(String key) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        this.readLock.lock();
        try {
            if (this.hasKey(key).booleanValue()) {
                CacheObj cacheObj = this.get(key);
                long l = cacheObj.getExpire();
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int incrementAndGet(String key) {
        Assert.notNull((Object)key, (String)"The object argument [key] must be null");
        int value = 0;
        CacheObj cacheObj = this.get(key);
        value = null == cacheObj ? 1 : cacheObj.getValue() + 1;
        this.set(key, value);
        return value;
    }

    @Override
    public void clear() {
        Iterator<CacheObj> it = STORE.values().iterator();
        CacheObj cacheObj = null;
        while (it.hasNext()) {
            cacheObj = it.next();
            if (cacheObj.getExpire() > 0L) continue;
            it.remove();
        }
    }
}

