/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.braum.spring.boot;

import javax.annotation.PostConstruct;
import me.zhyd.braum.spring.boot.BraumCacheType;
import me.zhyd.braum.spring.boot.BraumProcessor;
import me.zhyd.braum.spring.boot.BraumShieldProcessor;
import me.zhyd.braum.spring.boot.annotation.EnableBraumConfiguration;
import me.zhyd.braum.spring.boot.cache.Cache;
import me.zhyd.braum.spring.boot.cache.ConcurrentHashMapCache;
import me.zhyd.braum.spring.boot.cache.RedisCache;
import me.zhyd.braum.spring.boot.property.BraumProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(annotation={EnableBraumConfiguration.class})
@EnableConfigurationProperties(value={BraumProperties.class})
public class BraumAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BraumAutoConfiguration.class);
    @Autowired
    BraumProperties properties;

    @PostConstruct
    public void init() {
        log.info("Braum has been turned on! Best wishes for you! ");
        log.info("You'll be safe with braum... ");
    }

    @Bean
    @ConditionalOnMissingBean(name={"braumProcessor"})
    BraumProcessor BraumProcessor() {
        return new BraumShieldProcessor();
    }

    @Bean(name={"braumCache"})
    Cache braumCache() {
        BraumCacheType type = this.properties.getType();
        if (type == BraumCacheType.REDIS) {
            log.info("Enabling Braum cache: [Redis]");
            return new RedisCache();
        }
        log.info("Enabling Braum cache: [Map]");
        return new ConcurrentHashMapCache();
    }
}

