/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.constraint;

import java.lang.reflect.Array;
import org.jmock.core.Constraint;
import org.jmock.core.Formatting;

public class IsEqual
implements Constraint {
    private Object object;

    public IsEqual(Object equalArg) {
        this.object = equalArg;
    }

    public boolean eval(Object arg) {
        return IsEqual.areEqual(this.object, arg);
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        return buffer.append("eq(").append(Formatting.toReadableString(this.object)).append(")");
    }

    private static boolean areEqual(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == null && o2 == null;
        }
        if (IsEqual.isArray(o1)) {
            return IsEqual.isArray(o2) && IsEqual.areArraysEqual(o1, o2);
        }
        return o1.equals(o2);
    }

    private static boolean areArraysEqual(Object o1, Object o2) {
        return IsEqual.areArrayLengthsEqual(o1, o2) && IsEqual.areArrayElementsEqual(o1, o2);
    }

    private static boolean areArrayLengthsEqual(Object o1, Object o2) {
        return Array.getLength(o1) == Array.getLength(o2);
    }

    private static boolean areArrayElementsEqual(Object o1, Object o2) {
        for (int i = 0; i < Array.getLength(o1); ++i) {
            if (IsEqual.areEqual(Array.get(o1, i), Array.get(o2, i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isArray(Object o) {
        return o.getClass().isArray();
    }
}

