/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.mysql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Row2;
import org.jooq.SelectOffsetStep;
import org.jooq.impl.DSL;
import zipkin.internal.Pair;
import zipkin.storage.mysql.DSLContexts;
import zipkin.storage.mysql.HasIpv6;
import zipkin.storage.mysql.HasPreAggregatedDependencies;
import zipkin.storage.mysql.HasTraceIdHigh;
import zipkin.storage.mysql.internal.generated.tables.ZipkinAnnotations;
import zipkin.storage.mysql.internal.generated.tables.ZipkinSpans;

final class Schema {
    final List<Field<?>> spanIdFields;
    final List<Field<?>> spanFields;
    final List<Field<?>> annotationFields;
    final List<Field<?>> dependencyLinkFields;
    final List<Field<?>> dependencyLinkGroupByFields;
    final boolean hasTraceIdHigh;
    final boolean hasPreAggregatedDependencies;
    final boolean hasIpv6;

    Schema(DataSource datasource, DSLContexts context) {
        this.hasTraceIdHigh = HasTraceIdHigh.test(datasource, context);
        this.hasPreAggregatedDependencies = HasPreAggregatedDependencies.test(datasource, context);
        this.hasIpv6 = HasIpv6.test(datasource, context);
        this.spanIdFields = Schema.list(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID);
        this.spanFields = Schema.list(ZipkinSpans.ZIPKIN_SPANS.fields());
        this.annotationFields = Schema.list(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.fields());
        this.dependencyLinkFields = Schema.list(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID, ZipkinSpans.ZIPKIN_SPANS.PARENT_ID, ZipkinSpans.ZIPKIN_SPANS.ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME);
        this.dependencyLinkGroupByFields = new ArrayList(this.dependencyLinkFields);
        this.dependencyLinkGroupByFields.remove(ZipkinSpans.ZIPKIN_SPANS.PARENT_ID);
        if (!this.hasTraceIdHigh) {
            this.spanIdFields.remove(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
            this.spanFields.remove(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
            this.annotationFields.remove(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH);
            this.dependencyLinkFields.remove(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
            this.dependencyLinkGroupByFields.remove(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
        }
        if (!this.hasIpv6) {
            this.annotationFields.remove(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV6);
        }
    }

    Condition joinCondition(ZipkinAnnotations annotationTable) {
        if (this.hasTraceIdHigh) {
            return ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH.eq(annotationTable.TRACE_ID_HIGH).and(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(annotationTable.TRACE_ID)).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(annotationTable.SPAN_ID));
        }
        return ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(annotationTable.TRACE_ID).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(annotationTable.SPAN_ID));
    }

    static <T> List<T> list(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }

    Condition spanTraceIdCondition(SelectOffsetStep<? extends Record> traceIdQuery) {
        if (this.hasTraceIdHigh) {
            Result result = traceIdQuery.fetch();
            ArrayList<Row2> traceIds = new ArrayList<Row2>(result.size());
            for (Record r : result) {
                traceIds.add(DSL.row((Object)((Long)r.get(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH)), (Object)((Long)r.get(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID))));
            }
            return DSL.row(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID).in(traceIds);
        }
        List traceIds = traceIdQuery.fetch(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID);
        return ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.in((Collection)traceIds);
    }

    Condition spanTraceIdCondition(Long traceIdHigh, long traceIdLow) {
        return traceIdHigh != null && this.hasTraceIdHigh ? DSL.row(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID).eq((Object)traceIdHigh, (Object)traceIdLow) : ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq((Object)traceIdLow);
    }

    Condition annotationsTraceIdCondition(Set<Pair<Long>> traceIds) {
        Object[] result;
        boolean hasTraceIdHigh = false;
        for (Pair<Long> traceId : traceIds) {
            if ((Long)traceId._1 == 0L) continue;
            hasTraceIdHigh = true;
            break;
        }
        if (hasTraceIdHigh) {
            result = new Row2[traceIds.size()];
            int i = 0;
            for (Pair<Long> traceId128 : traceIds) {
                result[i++] = DSL.row((Object)((Long)traceId128._1), (Object)((Long)traceId128._2));
            }
            return DSL.row(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID).in((Row2[])result);
        }
        result = new Long[traceIds.size()];
        int i = 0;
        for (Pair<Long> traceId128 : traceIds) {
            result[i++] = (Long)traceId128._2;
        }
        return ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID.in(result);
    }
}

