/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import java.io.IOException;
import java.util.List;
import okhttp3.OkHttpClient;
import zipkin.internal.Nullable;
import zipkin.internal.V2StorageComponent;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.elasticsearch.http.LegacyElasticsearchHttpSpanStore;
import zipkin2.CheckResult;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;

public final class ElasticsearchHttpStorage
extends StorageComponent
implements V2StorageComponent.LegacySpanStoreProvider {
    public final ElasticsearchStorage delegate;
    final boolean legacyReadsEnabled;

    public static Builder builder(OkHttpClient client) {
        return new Builder(ElasticsearchStorage.newBuilder((OkHttpClient)client)).legacyReadsEnabled(true);
    }

    public static Builder builder() {
        return new Builder(ElasticsearchStorage.newBuilder()).legacyReadsEnabled(true);
    }

    public final Builder toBuilder() {
        return new Builder(ElasticsearchStorage.newBuilder()).legacyReadsEnabled(true);
    }

    ElasticsearchHttpStorage(ElasticsearchStorage delegate, boolean legacyReadsEnabled) {
        this.delegate = delegate;
        this.legacyReadsEnabled = legacyReadsEnabled;
    }

    public SpanStore spanStore() {
        return this.delegate.spanStore();
    }

    public SpanConsumer spanConsumer() {
        return this.delegate.spanConsumer();
    }

    @Nullable
    public AsyncSpanStore legacyAsyncSpanStore() {
        if (!this.legacyReadsEnabled) {
            return null;
        }
        if (this.delegate.version() >= 6.0f) {
            return null;
        }
        return new LegacyElasticsearchHttpSpanStore(this.delegate);
    }

    public CheckResult check() {
        return this.delegate.check();
    }

    void clear() throws IOException {
        this.delegate.clear();
    }

    public void close() {
        this.delegate.close();
    }

    public static final class Builder
    extends StorageComponent.Builder {
        final ElasticsearchStorage.Builder delegate;
        private boolean legacyReadsEnabled;

        Builder(ElasticsearchStorage.Builder delegate) {
            this.delegate = delegate;
        }

        public final Builder hosts(List<String> hosts) {
            this.delegate.hosts(hosts);
            return this;
        }

        public final Builder hostsSupplier(ElasticsearchStorage.HostsSupplier hosts) {
            this.delegate.hostsSupplier(hosts);
            return this;
        }

        public final Builder maxRequests(int maxRequests) {
            this.delegate.maxRequests(maxRequests);
            return this;
        }

        public final Builder pipeline(String pipeline) {
            this.delegate.pipeline(pipeline);
            return this;
        }

        public final Builder namesLookback(int namesLookback) {
            this.delegate.namesLookback(namesLookback);
            return this;
        }

        public final Builder legacyReadsEnabled(boolean legacyReadsEnabled) {
            this.legacyReadsEnabled = legacyReadsEnabled;
            return this;
        }

        public final Builder flushOnWrites(boolean flushOnWrites) {
            this.delegate.flushOnWrites(flushOnWrites);
            return this;
        }

        public final Builder index(String index) {
            this.delegate.index(index);
            return this;
        }

        public final Builder dateSeparator(char dateSeparator) {
            this.delegate.dateSeparator(dateSeparator);
            return this;
        }

        public final Builder indexShards(int indexShards) {
            this.delegate.indexShards(indexShards);
            return this;
        }

        public final Builder indexReplicas(int indexReplicas) {
            this.delegate.indexReplicas(indexReplicas);
            return this;
        }

        public final Builder strictTraceId(boolean strictTraceId) {
            this.delegate.strictTraceId(strictTraceId);
            return this;
        }

        public final ElasticsearchHttpStorage build() {
            return new ElasticsearchHttpStorage(this.delegate.build(), this.legacyReadsEnabled);
        }
    }

    public static interface HostsSupplier
    extends ElasticsearchStorage.HostsSupplier {
    }
}

