/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http.internal.client;

import java.io.Closeable;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import zipkin.internal.CallbackCaptor;
import zipkin.internal.Util;
import zipkin.storage.Callback;

public final class HttpCall<V> {
    final Call.Factory ok;
    final Request request;
    final BodyConverter<V> bodyConverter;

    HttpCall(Factory factory, Request request, BodyConverter<V> bodyConverter) {
        this.ok = factory.ok;
        this.request = request;
        this.bodyConverter = bodyConverter;
    }

    public void submit(Callback<V> delegate) {
        this.ok.newCall(this.request).enqueue(new CallbackAdapter<V>(this.bodyConverter, delegate));
    }

    static class CallbackAdapter<V>
    implements okhttp3.Callback {
        final BodyConverter<V> bodyConverter;
        final Callback<V> delegate;

        CallbackAdapter(BodyConverter<V> bodyConverter, Callback<V> delegate) {
            this.bodyConverter = bodyConverter;
            this.delegate = delegate;
        }

        public void onFailure(Call call, IOException e) {
            this.delegate.onError((Throwable)e);
        }

        public void onResponse(Call call, Response response) {
            if (!HttpHeaders.hasBody((Response)response)) {
                if (response.isSuccessful()) {
                    this.delegate.onSuccess(null);
                } else {
                    this.delegate.onError((Throwable)new IllegalStateException("response failed: " + response));
                }
                return;
            }
            try (ResponseBody responseBody = response.body();){
                BufferedSource content = responseBody.source();
                if ("gzip".equalsIgnoreCase(response.header("Content-Encoding"))) {
                    content = Okio.buffer((Source)new GzipSource((Source)responseBody.source()));
                }
                if (response.isSuccessful()) {
                    this.delegate.onSuccess(this.bodyConverter.convert(content));
                } else {
                    this.delegate.onError((Throwable)new IllegalStateException("response for " + response.request().tag() + " failed: " + content.readUtf8()));
                }
            }
            catch (Throwable t) {
                Util.propagateIfFatal((Throwable)t);
                this.delegate.onError(t);
            }
        }
    }

    public static class Factory
    implements Closeable {
        final OkHttpClient ok;
        public final HttpUrl baseUrl;

        public Factory(OkHttpClient ok, HttpUrl baseUrl) {
            this.ok = ok;
            this.baseUrl = baseUrl;
        }

        public <V> HttpCall<V> newCall(Request request, BodyConverter<V> bodyConverter) {
            return new HttpCall<V>(this, request, bodyConverter);
        }

        public <V> V execute(Request request, BodyConverter<V> bodyConverter) {
            CallbackCaptor response = new CallbackCaptor();
            this.newCall(request, bodyConverter).submit((Callback<V>)response);
            return (V)response.get();
        }

        @Override
        public void close() {
            this.ok.dispatcher().executorService().shutdownNow();
        }
    }

    public static interface BodyConverter<V> {
        public V convert(BufferedSource var1) throws IOException;
    }
}

