/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.DependencyLinker;
import zipkin.internal.MergeById;
import zipkin.internal.Nullable;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin.storage.elasticsearch.http.internal.LenientDoubleCallback;

public final class LenientDoubleCallbackAsyncSpanStore
implements AsyncSpanStore {
    final AsyncSpanStore left;
    final AsyncSpanStore right;

    public LenientDoubleCallbackAsyncSpanStore(AsyncSpanStore left, AsyncSpanStore right) {
        this.left = left;
        this.right = right;
    }

    public void getTraces(QueryRequest request, Callback<List<List<Span>>> callback) {
        GetTracesDoubleCallback doubleCallback = new GetTracesDoubleCallback(callback);
        this.left.getTraces(request, (Callback)doubleCallback);
        this.right.getTraces(request, (Callback)doubleCallback);
    }

    @Deprecated
    public void getTrace(long id, Callback<List<Span>> callback) {
        this.getTrace(0L, id, callback);
    }

    public void getTrace(long traceIdHigh, long traceIdLow, Callback<List<Span>> callback) {
        GetTraceDoubleCallback doubleCallback = new GetTraceDoubleCallback(callback);
        this.left.getTrace(traceIdHigh, traceIdLow, (Callback)doubleCallback);
        this.right.getTrace(traceIdHigh, traceIdLow, (Callback)doubleCallback);
    }

    @Deprecated
    public void getRawTrace(long traceId, Callback<List<Span>> callback) {
        this.getRawTrace(0L, traceId, callback);
    }

    public void getRawTrace(long traceIdHigh, long traceIdLow, Callback<List<Span>> callback) {
        GetRawTraceDoubleCallback doubleCallback = new GetRawTraceDoubleCallback(callback);
        this.left.getRawTrace(traceIdHigh, traceIdLow, (Callback)doubleCallback);
        this.right.getRawTrace(traceIdHigh, traceIdLow, (Callback)doubleCallback);
    }

    public void getServiceNames(Callback<List<String>> callback) {
        StringsDoubleCallback doubleCallback = new StringsDoubleCallback(callback);
        this.left.getServiceNames((Callback)doubleCallback);
        this.right.getServiceNames((Callback)doubleCallback);
    }

    public void getSpanNames(String serviceName, Callback<List<String>> callback) {
        StringsDoubleCallback doubleCallback = new StringsDoubleCallback(callback);
        this.left.getSpanNames(serviceName, (Callback)doubleCallback);
        this.right.getSpanNames(serviceName, (Callback)doubleCallback);
    }

    public void getDependencies(long endTs, Long lookback, Callback<List<DependencyLink>> callback) {
        GetDependenciesDoubleCallback doubleCallback = new GetDependenciesDoubleCallback(callback);
        this.left.getDependencies(endTs, lookback, (Callback)doubleCallback);
        this.right.getDependencies(endTs, lookback, (Callback)doubleCallback);
    }

    public String toString() {
        return "LenientDoubleCallbackAsyncSpanStore(" + this.left + "," + this.right + ")";
    }

    static final class GetDependenciesDoubleCallback
    extends LenientDoubleCallback<List<DependencyLink>> {
        static final Logger LOG = Logger.getLogger(GetDependenciesDoubleCallback.class.getName());

        GetDependenciesDoubleCallback(Callback<List<DependencyLink>> delegate) {
            super(LOG, delegate);
        }

        @Override
        List<DependencyLink> merge(List<DependencyLink> v1, List<DependencyLink> v2) {
            ArrayList<DependencyLink> concat = new ArrayList<DependencyLink>(v1);
            concat.addAll(v2);
            return DependencyLinker.merge(concat);
        }
    }

    static final class StringsDoubleCallback
    extends LenientDoubleCallback<List<String>> {
        static final Logger LOG = Logger.getLogger(StringsDoubleCallback.class.getName());

        StringsDoubleCallback(Callback<List<String>> delegate) {
            super(LOG, delegate);
        }

        @Override
        List<String> merge(List<String> v1, List<String> v2) {
            LinkedHashSet<String> result = new LinkedHashSet<String>(v1);
            result.addAll(v2);
            return new ArrayList<String>(result);
        }
    }

    static final class GetRawTraceDoubleCallback
    extends LenientDoubleCallback<List<Span>> {
        static final Logger LOG = Logger.getLogger(GetRawTraceDoubleCallback.class.getName());

        GetRawTraceDoubleCallback(Callback<List<Span>> delegate) {
            super(LOG, delegate);
        }

        @Override
        List<Span> merge(@Nullable List<Span> v1, @Nullable List<Span> v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            ArrayList<Span> result = new ArrayList<Span>(v1);
            result.addAll(v2);
            return result;
        }
    }

    static final class GetTraceDoubleCallback
    extends LenientDoubleCallback<List<Span>> {
        static final Logger LOG = Logger.getLogger(GetTraceDoubleCallback.class.getName());

        GetTraceDoubleCallback(Callback<List<Span>> delegate) {
            super(LOG, delegate);
        }

        @Override
        List<Span> merge(@Nullable List<Span> v1, @Nullable List<Span> v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            ArrayList<Span> result = new ArrayList<Span>(v1);
            result.addAll(v2);
            return MergeById.apply(result);
        }
    }

    static final class GetTracesDoubleCallback
    extends LenientDoubleCallback<List<List<Span>>> {
        static final Logger LOG = Logger.getLogger(GetTracesDoubleCallback.class.getName());

        GetTracesDoubleCallback(Callback<List<List<Span>>> delegate) {
            super(LOG, delegate);
        }

        @Override
        List<List<Span>> merge(List<List<Span>> v1, List<List<Span>> v2) {
            ArrayList<List<Span>> result = new ArrayList<List<Span>>(v1);
            result.addAll(v2);
            return result;
        }
    }
}

