/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import okio.Buffer;
import okio.ByteString;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.Util;
import zipkin.storage.elasticsearch.http.JsonAdapters;

final class LegacyJsonAdapters {
    static final JsonAdapter<Span> SPAN_ADAPTER = new JsonAdapter<Span>(){

        public Span fromJson(JsonReader reader) throws IOException {
            Span.Builder result = Span.builder();
            reader.beginObject();
            block22: while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (reader.peek() == JsonReader.Token.NULL) {
                    reader.skipValue();
                    continue;
                }
                switch (nextName) {
                    case "traceId": {
                        String traceId = reader.nextString();
                        if (traceId.length() == 32) {
                            result.traceIdHigh(Util.lowerHexToUnsignedLong((String)traceId, (int)0));
                        }
                        result.traceId(Util.lowerHexToUnsignedLong((String)traceId));
                        continue block22;
                    }
                    case "name": {
                        result.name(reader.nextString());
                        continue block22;
                    }
                    case "id": {
                        result.id(Util.lowerHexToUnsignedLong((String)reader.nextString()));
                        continue block22;
                    }
                    case "parentId": {
                        result.parentId(Long.valueOf(Util.lowerHexToUnsignedLong((String)reader.nextString())));
                        continue block22;
                    }
                    case "timestamp": {
                        result.timestamp(Long.valueOf(reader.nextLong()));
                        continue block22;
                    }
                    case "duration": {
                        result.duration(Long.valueOf(reader.nextLong()));
                        continue block22;
                    }
                    case "annotations": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            result.addAnnotation((Annotation)JsonAdapters.ANNOTATION_ADAPTER.fromJson(reader));
                        }
                        reader.endArray();
                        continue block22;
                    }
                    case "binaryAnnotations": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            result.addBinaryAnnotation((BinaryAnnotation)BINARY_ANNOTATION_ADAPTER.fromJson(reader));
                        }
                        reader.endArray();
                        continue block22;
                    }
                    case "debug": {
                        result.debug(Boolean.valueOf(reader.nextBoolean()));
                        continue block22;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        public void toJson(JsonWriter writer, Span value) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    static final JsonAdapter<BinaryAnnotation> BINARY_ANNOTATION_ADAPTER = new JsonAdapter<BinaryAnnotation>(){

        public BinaryAnnotation fromJson(JsonReader reader) throws IOException {
            BinaryAnnotation.Builder result = BinaryAnnotation.builder();
            String number = null;
            String string = null;
            BinaryAnnotation.Type type = BinaryAnnotation.Type.STRING;
            reader.beginObject();
            block27: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "key": {
                        result.key(reader.nextString());
                        continue block27;
                    }
                    case "value": {
                        switch (reader.peek()) {
                            case BOOLEAN: {
                                byte[] byArray;
                                type = BinaryAnnotation.Type.BOOL;
                                if (reader.nextBoolean()) {
                                    byte[] byArray2 = new byte[1];
                                    byArray = byArray2;
                                    byArray2[0] = 1;
                                } else {
                                    byte[] byArray3 = new byte[1];
                                    byArray = byArray3;
                                    byArray3[0] = 0;
                                }
                                result.value(byArray);
                                continue block27;
                            }
                            case STRING: {
                                string = reader.nextString();
                                continue block27;
                            }
                            case NUMBER: {
                                number = reader.nextString();
                                continue block27;
                            }
                        }
                        throw new JsonDataException("Expected value to be a boolean, string or number but was " + reader.peek() + " at path " + reader.getPath());
                    }
                    case "type": {
                        type = BinaryAnnotation.Type.valueOf((String)reader.nextString());
                        continue block27;
                    }
                    case "endpoint": {
                        result.endpoint((Endpoint)JsonAdapters.ENDPOINT_ADAPTER.fromJson(reader));
                        continue block27;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            result.type(type);
            switch (type) {
                case BOOL: {
                    return result.build();
                }
                case STRING: {
                    return result.value(string.getBytes(Util.UTF_8)).build();
                }
                case BYTES: {
                    return result.value(ByteString.decodeBase64(string).toByteArray()).build();
                }
            }
            Buffer buffer = new Buffer();
            switch (type) {
                case I16: {
                    buffer.writeShort((int)Short.parseShort(number));
                    break;
                }
                case I32: {
                    buffer.writeInt(Integer.parseInt(number));
                    break;
                }
                case I64: 
                case DOUBLE: {
                    if (number == null) {
                        number = string;
                    }
                    long v = type == BinaryAnnotation.Type.I64 ? Long.parseLong(number) : Double.doubleToRawLongBits(Double.parseDouble(number));
                    buffer.writeLong(v);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("BinaryAnnotationType " + type + " was added, but not handled"));
                }
            }
            return result.value(buffer.readByteArray()).build();
        }

        public void toJson(JsonWriter writer, BinaryAnnotation value) throws IOException {
            throw new UnsupportedOperationException();
        }
    };

    LegacyJsonAdapters() {
    }
}

