/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.GroupByTraceId;
import zipkin.internal.MergeById;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin.storage.elasticsearch.http.BodyConverters;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage;
import zipkin.storage.elasticsearch.http.IndexNameFormatter;
import zipkin.storage.elasticsearch.http.LegacyJsonAdapters;
import zipkin.storage.elasticsearch.http.internal.client.Aggregation;
import zipkin.storage.elasticsearch.http.internal.client.HttpCall;
import zipkin.storage.elasticsearch.http.internal.client.SearchCallFactory;
import zipkin.storage.elasticsearch.http.internal.client.SearchRequest;
import zipkin.storage.elasticsearch.http.internal.client.SearchResultConverter;

final class LegacyElasticsearchHttpSpanStore
implements AsyncSpanStore {
    static final String SPAN = "span";
    static final String DEPENDENCY_LINK = "dependencylink";
    static final String SERVICE_SPAN = "servicespan";
    static final HttpCall.BodyConverter<List<Span>> SPANS = SearchResultConverter.create(LegacyJsonAdapters.SPAN_ADAPTER);
    static final HttpCall.BodyConverter<List<Span>> NULLABLE_SPANS = SearchResultConverter.create(LegacyJsonAdapters.SPAN_ADAPTER).defaultToNull();
    final SearchCallFactory search;
    final String[] allIndices;
    final IndexNameFormatter indexNameFormatter;
    final boolean strictTraceId;
    final int namesLookback;

    LegacyElasticsearchHttpSpanStore(ElasticsearchHttpStorage es) {
        this.search = new SearchCallFactory(es.http());
        this.allIndices = new String[]{es.indexNameFormatter().formatType(null)};
        this.indexNameFormatter = es.indexNameFormatter();
        this.strictTraceId = es.strictTraceId();
        this.namesLookback = es.namesLookback();
    }

    public void getTraces(final QueryRequest request, final Callback<List<List<Span>>> callback) {
        long beginMillis = request.endTs - request.lookback;
        long endMillis = request.endTs;
        SearchRequest.Filters filters = new SearchRequest.Filters();
        filters.addRange("timestamp_millis", beginMillis, endMillis);
        if (request.serviceName != null) {
            filters.addNestedTerms(Arrays.asList("annotations.endpoint.serviceName", "binaryAnnotations.endpoint.serviceName"), request.serviceName);
        }
        if (request.spanName != null) {
            filters.addTerm("name", request.spanName);
        }
        for (String string : request.annotations) {
            LinkedHashMap<String, String> annotationValues = new LinkedHashMap<String, String>();
            annotationValues.put("annotations.value", string);
            LinkedHashMap<String, String> binaryAnnotationKeys = new LinkedHashMap<String, String>();
            binaryAnnotationKeys.put("binaryAnnotations.key", string);
            if (request.serviceName != null) {
                annotationValues.put("annotations.endpoint.serviceName", request.serviceName);
                binaryAnnotationKeys.put("binaryAnnotations.endpoint.serviceName", request.serviceName);
            }
            filters.addNestedTerms(annotationValues, binaryAnnotationKeys);
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            LinkedHashMap<String, String> nestedTerms = new LinkedHashMap<String, String>();
            nestedTerms.put("binaryAnnotations.key", (String)entry.getKey());
            nestedTerms.put("binaryAnnotations.value", (String)entry.getValue());
            if (request.serviceName != null) {
                nestedTerms.put("binaryAnnotations.endpoint.serviceName", request.serviceName);
            }
            filters.addNestedTerms(nestedTerms);
        }
        if (request.minDuration != null) {
            filters.addRange("duration", request.minDuration, request.maxDuration);
        }
        Aggregation traceIdTimestamp = Aggregation.terms("traceId", request.limit).addSubAggregation(Aggregation.min("timestamp_millis")).orderBy("timestamp_millis", "desc");
        final List<String> list = this.indexNameFormatter.formatTypeAndRange(null, beginMillis, endMillis);
        SearchRequest esRequest = SearchRequest.create(list, SPAN).filters(filters).addAggregation(traceIdTimestamp);
        HttpCall<List<String>> traceIdsCall = this.search.newCall(esRequest, BodyConverters.SORTED_KEYS);
        Callback<List<Span>> successCallback = new Callback<List<Span>>(){

            public void onSuccess(List<Span> input) {
                List traces = GroupByTraceId.apply(input, (boolean)LegacyElasticsearchHttpSpanStore.this.strictTraceId, (boolean)true);
                Iterator trace = traces.iterator();
                while (trace.hasNext()) {
                    List next = (List)trace.next();
                    if (((Span)next.get((int)0)).traceIdHigh == 0L || request.test(next)) continue;
                    trace.remove();
                }
                callback.onSuccess((Object)traces);
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        };
        traceIdsCall.submit(new Callback<List<String>>((Callback)successCallback){
            final /* synthetic */ Callback val$successCallback;
            {
                this.val$successCallback = callback2;
            }

            public void onSuccess(@Nullable List<String> traceIds) {
                if (traceIds == null || traceIds.isEmpty()) {
                    callback.onSuccess(Collections.emptyList());
                    return;
                }
                SearchRequest request = SearchRequest.create(list, LegacyElasticsearchHttpSpanStore.SPAN).terms("traceId", traceIds);
                LegacyElasticsearchHttpSpanStore.this.search.newCall(request, SPANS).submit((Callback<List<Span>>)this.val$successCallback);
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void getTrace(long id, Callback<List<Span>> callback) {
        this.getTrace(0L, id, callback);
    }

    public void getTrace(long traceIdHigh, long traceIdLow, final Callback<List<Span>> callback) {
        this.getRawTrace(traceIdHigh, traceIdLow, new Callback<List<Span>>(){

            public void onSuccess(@Nullable List<Span> value) {
                List result = CorrectForClockSkew.apply((List)MergeById.apply(value));
                callback.onSuccess((Object)(result.isEmpty() ? null : result));
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void getRawTrace(long traceId, Callback<List<Span>> callback) {
        this.getRawTrace(0L, traceId, callback);
    }

    public void getRawTrace(long traceIdHigh, long traceIdLow, Callback<List<Span>> callback) {
        String traceIdHex = Util.toLowerHex((long)(this.strictTraceId ? traceIdHigh : 0L), (long)traceIdLow);
        SearchRequest request = SearchRequest.create(Arrays.asList(this.allIndices), SPAN).term("traceId", traceIdHex);
        this.search.newCall(request, NULLABLE_SPANS).submit(callback);
    }

    public void getServiceNames(final Callback<List<String>> callback) {
        final long endMillis = System.currentTimeMillis();
        final long beginMillis = endMillis - (long)this.namesLookback;
        final List<String> indices = this.indexNameFormatter.formatTypeAndRange(null, beginMillis, endMillis);
        SearchRequest request = SearchRequest.create(indices, SERVICE_SPAN).addAggregation(Aggregation.terms("serviceName", Integer.MAX_VALUE));
        this.search.newCall(request, BodyConverters.SORTED_KEYS).submit(new Callback<List<String>>(){

            public void onSuccess(List<String> value) {
                if (!value.isEmpty()) {
                    callback.onSuccess(value);
                }
                SearchRequest.Filters filters = new SearchRequest.Filters();
                filters.addRange("timestamp_millis", beginMillis, endMillis);
                SearchRequest request = SearchRequest.create(indices, LegacyElasticsearchHttpSpanStore.SPAN).filters(filters).addAggregation(Aggregation.nestedTerms("annotations.endpoint.serviceName")).addAggregation(Aggregation.nestedTerms("binaryAnnotations.endpoint.serviceName"));
                LegacyElasticsearchHttpSpanStore.this.search.newCall(request, BodyConverters.SORTED_KEYS).submit((Callback<List<String>>)callback);
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void getSpanNames(final String serviceName, final Callback<List<String>> callback) {
        if (serviceName == null || "".equals(serviceName)) {
            callback.onSuccess(Collections.emptyList());
            return;
        }
        final long endMillis = System.currentTimeMillis();
        final long beginMillis = endMillis - (long)this.namesLookback;
        final List<String> indices = this.indexNameFormatter.formatTypeAndRange(null, beginMillis, endMillis);
        SearchRequest request = SearchRequest.create(indices, SERVICE_SPAN).term("serviceName", serviceName.toLowerCase(Locale.ROOT)).addAggregation(Aggregation.terms("spanName", Integer.MAX_VALUE));
        this.search.newCall(request, BodyConverters.SORTED_KEYS).submit(new Callback<List<String>>(){

            public void onSuccess(List<String> value) {
                if (!value.isEmpty()) {
                    callback.onSuccess(value);
                }
                SearchRequest.Filters filters = new SearchRequest.Filters();
                filters.addRange("timestamp_millis", beginMillis, endMillis);
                filters.addNestedTerms(Arrays.asList("annotations.endpoint.serviceName", "binaryAnnotations.endpoint.serviceName"), serviceName.toLowerCase(Locale.ROOT));
                SearchRequest request = SearchRequest.create(indices, LegacyElasticsearchHttpSpanStore.SPAN).filters(filters).addAggregation(Aggregation.terms("name", Integer.MAX_VALUE));
                LegacyElasticsearchHttpSpanStore.this.search.newCall(request, BodyConverters.SORTED_KEYS).submit((Callback<List<String>>)callback);
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void getDependencies(long endTs, @Nullable Long lookback, Callback<List<DependencyLink>> callback) {
        long beginMillis = lookback != null ? endTs - lookback : 0L;
        List<String> indices = this.indexNameFormatter.formatTypeAndRange(null, beginMillis, endTs);
        this.getDependencies(indices, callback);
    }

    void getDependencies(List<String> indices, Callback<List<DependencyLink>> callback) {
        SearchRequest request = SearchRequest.create(indices, DEPENDENCY_LINK);
        this.search.newCall(request, BodyConverters.DEPENDENCY_LINKS).submit(callback);
    }
}

