/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import okio.Buffer;
import okio.BufferedSink;
import zipkin.Codec;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.internal.Pair;
import zipkin.internal.Util;
import zipkin.storage.Callback;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpSpanConsumer;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage;

class LegacyElasticsearchHttpSpanConsumer
extends ElasticsearchHttpSpanConsumer {
    private static final byte[] TIMESTAMP_MILLIS_PREFIX = "{\"timestamp_millis\":".getBytes(Util.UTF_8);

    LegacyElasticsearchHttpSpanConsumer(ElasticsearchHttpStorage es) {
        super(es);
    }

    @Override
    MultiTypeBulkSpanIndexer newBulkSpanIndexer(ElasticsearchHttpStorage es) {
        return new MultiTypeBulkSpanIndexer(es);
    }

    static byte[] prefixWithTimestampMillis(byte[] input, long timestampMillis) {
        String dateAsString = Long.toString(timestampMillis);
        byte[] newSpanBytes = new byte[TIMESTAMP_MILLIS_PREFIX.length + dateAsString.length() + input.length];
        int pos = 0;
        System.arraycopy(TIMESTAMP_MILLIS_PREFIX, 0, newSpanBytes, pos, TIMESTAMP_MILLIS_PREFIX.length);
        pos += TIMESTAMP_MILLIS_PREFIX.length;
        int length = dateAsString.length();
        for (int i = 0; i < length; ++i) {
            newSpanBytes[pos++] = (byte)dateAsString.charAt(i);
        }
        newSpanBytes[pos++] = 44;
        System.arraycopy(input, 1, newSpanBytes, pos, input.length - 1);
        return newSpanBytes;
    }

    static class MultiTypeBulkSpanIndexer
    extends ElasticsearchHttpSpanConsumer.BulkSpanIndexer {
        Map<String, Set<Pair<String>>> indexToServiceSpans = new LinkedHashMap<String, Set<Pair<String>>>();

        MultiTypeBulkSpanIndexer(ElasticsearchHttpStorage es) {
            super(es);
        }

        @Override
        void add(long indexTimestamp, Span span, @Nullable Long spanTimestamp) {
            String type = null;
            String index = this.indexNameFormatter.formatTypeAndTimestamp(type, indexTimestamp);
            if (!span.name.isEmpty()) {
                this.putServiceSpans(this.indexToServiceSpans, index, span);
            }
            byte[] document = Codec.JSON.writeSpan(span);
            if (spanTimestamp != null) {
                document = LegacyElasticsearchHttpSpanConsumer.prefixWithTimestampMillis(document, spanTimestamp);
            }
            this.indexer.add(index, "span", document, null);
        }

        void putServiceSpans(Map<String, Set<Pair<String>>> indexToServiceSpans, String index, Span s) {
            Set<Pair<String>> serviceSpans = indexToServiceSpans.get(index);
            if (serviceSpans == null) {
                serviceSpans = new LinkedHashSet<Pair<String>>();
                indexToServiceSpans.put(index, serviceSpans);
            }
            for (String serviceName : s.serviceNames()) {
                serviceSpans.add((Pair<String>)Pair.create((Object)serviceName, (Object)s.name));
            }
        }

        @Override
        void execute(Callback<Void> callback) throws IOException {
            if (this.indexToServiceSpans.isEmpty()) {
                this.indexer.execute(callback);
                return;
            }
            Buffer buffer = new Buffer();
            for (Map.Entry<String, Set<Pair<String>>> entry : this.indexToServiceSpans.entrySet()) {
                String index = entry.getKey();
                for (Pair<String> serviceSpan : entry.getValue()) {
                    JsonWriter writer = JsonWriter.of((BufferedSink)buffer);
                    writer.beginObject();
                    writer.name("serviceName").value((String)serviceSpan._1);
                    writer.name("spanName").value((String)serviceSpan._2);
                    writer.endObject();
                    byte[] document = buffer.readByteArray();
                    this.indexer.add(index, "servicespan", document, (String)serviceSpan._1 + "|" + (String)serviceSpan._2);
                }
            }
            this.indexer.execute(callback);
        }
    }
}

