/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import zipkin.Annotation;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.Span2;
import zipkin.internal.Span2Converter;

final class JsonAdapters {
    static final JsonAdapter<Span> SPAN_ADAPTER = new JsonAdapter<Span>(){

        public Span fromJson(JsonReader reader) throws IOException {
            Span2.Builder result = Span2.builder();
            reader.beginObject();
            block30: while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (reader.peek() == JsonReader.Token.NULL) {
                    reader.skipValue();
                    continue;
                }
                switch (nextName) {
                    case "traceId": {
                        result.traceId(reader.nextString());
                        continue block30;
                    }
                    case "parentId": {
                        result.parentId(reader.nextString());
                        continue block30;
                    }
                    case "id": {
                        result.id(reader.nextString());
                        continue block30;
                    }
                    case "kind": {
                        result.kind(Span2.Kind.valueOf((String)reader.nextString()));
                        continue block30;
                    }
                    case "name": {
                        result.name(reader.nextString());
                        continue block30;
                    }
                    case "timestamp": {
                        result.timestamp(Long.valueOf(reader.nextLong()));
                        continue block30;
                    }
                    case "duration": {
                        result.duration(Long.valueOf(reader.nextLong()));
                        continue block30;
                    }
                    case "localEndpoint": {
                        result.localEndpoint((Endpoint)ENDPOINT_ADAPTER.fromJson(reader));
                        continue block30;
                    }
                    case "remoteEndpoint": {
                        result.remoteEndpoint((Endpoint)ENDPOINT_ADAPTER.fromJson(reader));
                        continue block30;
                    }
                    case "annotations": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            Annotation a = (Annotation)ANNOTATION_ADAPTER.fromJson(reader);
                            result.addAnnotation(a.timestamp, a.value);
                        }
                        reader.endArray();
                        continue block30;
                    }
                    case "tags": {
                        reader.beginObject();
                        while (reader.hasNext()) {
                            result.putTag(reader.nextName(), reader.nextString());
                        }
                        reader.endObject();
                        continue block30;
                    }
                    case "debug": {
                        result.debug(Boolean.valueOf(reader.nextBoolean()));
                        continue block30;
                    }
                    case "shared": {
                        result.shared(Boolean.valueOf(reader.nextBoolean()));
                        continue block30;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return Span2Converter.toSpan((Span2)result.build());
        }

        public void toJson(JsonWriter writer, Span value) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    static final JsonAdapter<Annotation> ANNOTATION_ADAPTER = new JsonAdapter<Annotation>(){

        public Annotation fromJson(JsonReader reader) throws IOException {
            Annotation.Builder result = Annotation.builder();
            reader.beginObject();
            block10: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "timestamp": {
                        result.timestamp(reader.nextLong());
                        continue block10;
                    }
                    case "value": {
                        result.value(reader.nextString());
                        continue block10;
                    }
                    case "endpoint": {
                        result.endpoint((Endpoint)ENDPOINT_ADAPTER.fromJson(reader));
                        continue block10;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        public void toJson(JsonWriter writer, Annotation value) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    static final JsonAdapter<Endpoint> ENDPOINT_ADAPTER = new JsonAdapter<Endpoint>(){

        public Endpoint fromJson(JsonReader reader) throws IOException {
            Endpoint.Builder result = Endpoint.builder().serviceName("");
            reader.beginObject();
            block11: while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (reader.peek() == JsonReader.Token.NULL) {
                    reader.skipValue();
                    continue;
                }
                switch (nextName) {
                    case "serviceName": {
                        result.serviceName(reader.nextString());
                        continue block11;
                    }
                    case "ipv4": 
                    case "ipv6": {
                        result.parseIp(reader.nextString());
                        continue block11;
                    }
                    case "port": {
                        result.port(reader.nextInt());
                        continue block11;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        public void toJson(JsonWriter writer, Endpoint value) throws IOException {
            throw new UnsupportedOperationException();
        }
    }.nullSafe();
    static final JsonAdapter<DependencyLink> DEPENDENCY_LINK_ADAPTER = new JsonAdapter<DependencyLink>(){

        public DependencyLink fromJson(JsonReader reader) throws IOException {
            DependencyLink.Builder result = DependencyLink.builder();
            reader.beginObject();
            block12: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "parent": {
                        result.parent(reader.nextString());
                        continue block12;
                    }
                    case "child": {
                        result.child(reader.nextString());
                        continue block12;
                    }
                    case "callCount": {
                        result.callCount(reader.nextLong());
                        continue block12;
                    }
                    case "errorCount": {
                        result.errorCount(reader.nextLong());
                        continue block12;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        public void toJson(JsonWriter writer, DependencyLink value) throws IOException {
            throw new UnsupportedOperationException();
        }
    };

    JsonAdapters() {
    }
}

