/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import zipkin.internal.JsonCodec;
import zipkin.internal.Nullable;
import zipkin.storage.Callback;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage;
import zipkin.storage.elasticsearch.http.HttpBulkIndexer$$Lambda$1;
import zipkin.storage.elasticsearch.http.internal.client.HttpCall;

final class HttpBulkIndexer {
    final String tag;
    final HttpCall.Factory http;
    final String pipeline;
    final boolean flushOnWrites;
    final Buffer body = new Buffer();
    final Set<String> indices = new LinkedHashSet<String>();

    HttpBulkIndexer(String tag, ElasticsearchHttpStorage es) {
        this.tag = tag;
        this.http = es.http();
        this.pipeline = es.pipeline();
        this.flushOnWrites = es.flushOnWrites();
    }

    void add(String index, String typeName, byte[] document, @Nullable String id) {
        this.writeIndexMetadata(index, typeName, id);
        this.writeDocument(document);
    }

    void writeIndexMetadata(String index, String typeName, @Nullable String id) {
        if (this.flushOnWrites) {
            this.indices.add(index);
        }
        this.body.writeUtf8("{\"index\":{\"_index\":\"").writeUtf8(index).writeByte(34);
        this.body.writeUtf8(",\"_type\":\"").writeUtf8(typeName).writeByte(34);
        if (id != null) {
            this.body.writeUtf8(",\"_id\":\"").writeUtf8(JsonCodec.escape((String)id)).writeByte(34);
        }
        this.body.writeUtf8("}}\n");
    }

    void writeDocument(byte[] document) {
        this.body.write(document);
        this.body.writeByte(10);
    }

    void execute(Callback<Void> callback) {
        HttpUrl url = this.pipeline != null ? this.http.baseUrl.newBuilder("_bulk").addQueryParameter("pipeline", this.pipeline).build() : this.http.baseUrl.resolve("_bulk");
        Request request = new Request.Builder().url(url).tag((Object)this.tag).post(RequestBody.create((MediaType)ElasticsearchHttpStorage.APPLICATION_JSON, (ByteString)this.body.readByteString())).build();
        this.http.newCall(request, HttpBulkIndexer$$Lambda$1.lambdaFactory$(this)).submit(callback);
    }

    static String join(Collection<String> parts) {
        Iterator<String> iterator = parts.iterator();
        StringBuilder result = new StringBuilder(iterator.next());
        while (iterator.hasNext()) {
            result.append(',').append(iterator.next());
        }
        return result.toString();
    }

    static /* synthetic */ Void lambda$execute$0(HttpBulkIndexer this_, BufferedSource b) throws IOException {
        String content = b.readUtf8();
        if (content.indexOf("\"errors\":true") != -1) {
            throw new IllegalStateException(content);
        }
        if (this_.indices.isEmpty()) {
            return null;
        }
        ElasticsearchHttpStorage.flush(this_.http, HttpBulkIndexer.join(this_.indices));
        return null;
    }
}

