/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.GroupByTraceId;
import zipkin.internal.MergeById;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin.storage.elasticsearch.http.BodyConverters;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage;
import zipkin.storage.elasticsearch.http.IndexNameFormatter;
import zipkin.storage.elasticsearch.http.internal.client.Aggregation;
import zipkin.storage.elasticsearch.http.internal.client.HttpCall;
import zipkin.storage.elasticsearch.http.internal.client.SearchCallFactory;
import zipkin.storage.elasticsearch.http.internal.client.SearchRequest;

final class ElasticsearchHttpSpanStore
implements AsyncSpanStore {
    static final String SPAN = "span";
    static final String DEPENDENCY = "dependency";
    final SearchCallFactory search;
    final String[] allSpanIndices;
    final IndexNameFormatter indexNameFormatter;
    final boolean strictTraceId;
    final int namesLookback;

    ElasticsearchHttpSpanStore(ElasticsearchHttpStorage es) {
        this.search = new SearchCallFactory(es.http());
        this.allSpanIndices = new String[]{es.indexNameFormatter().formatType(SPAN)};
        this.indexNameFormatter = es.indexNameFormatter();
        this.strictTraceId = es.strictTraceId();
        this.namesLookback = es.namesLookback();
    }

    public void getTraces(final QueryRequest request, final Callback<List<List<Span>>> callback) {
        long beginMillis = request.endTs - request.lookback;
        long endMillis = request.endTs;
        SearchRequest.Filters filters = new SearchRequest.Filters();
        filters.addRange("timestamp_millis", beginMillis, endMillis);
        if (request.serviceName != null) {
            filters.addTerm("localEndpoint.serviceName", request.serviceName);
        }
        if (request.spanName != null) {
            filters.addTerm("name", request.spanName);
        }
        for (String string : request.annotations) {
            filters.addTerm("_q", string);
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            filters.addTerm("_q", (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        if (request.minDuration != null) {
            filters.addRange("duration", request.minDuration, request.maxDuration);
        }
        Aggregation traceIdTimestamp = Aggregation.terms("traceId", request.limit).addSubAggregation(Aggregation.min("timestamp_millis")).orderBy("timestamp_millis", "desc");
        final List<String> list = this.indexNameFormatter.formatTypeAndRange(SPAN, beginMillis, endMillis);
        SearchRequest esRequest = SearchRequest.create(list).filters(filters).addAggregation(traceIdTimestamp);
        HttpCall<List<String>> traceIdsCall = this.search.newCall(esRequest, BodyConverters.SORTED_KEYS);
        Callback<List<Span>> successCallback = new Callback<List<Span>>(){

            public void onSuccess(List<Span> input) {
                List traces = GroupByTraceId.apply(input, (boolean)ElasticsearchHttpSpanStore.this.strictTraceId, (boolean)true);
                Iterator trace = traces.iterator();
                while (trace.hasNext()) {
                    List next = (List)trace.next();
                    if (((Span)next.get((int)0)).traceIdHigh == 0L || request.test(next)) continue;
                    trace.remove();
                }
                callback.onSuccess((Object)traces);
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        };
        traceIdsCall.submit(new Callback<List<String>>((Callback)successCallback){
            final /* synthetic */ Callback val$successCallback;
            {
                this.val$successCallback = callback2;
            }

            public void onSuccess(@Nullable List<String> traceIds) {
                if (traceIds == null || traceIds.isEmpty()) {
                    callback.onSuccess(Collections.emptyList());
                    return;
                }
                SearchRequest request = SearchRequest.create(list).terms("traceId", traceIds);
                ElasticsearchHttpSpanStore.this.search.newCall(request, BodyConverters.SPANS).submit((Callback<List<Span>>)this.val$successCallback);
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void getTrace(long id, Callback<List<Span>> callback) {
        this.getTrace(0L, id, callback);
    }

    public void getTrace(long traceIdHigh, long traceIdLow, final Callback<List<Span>> callback) {
        this.getRawTrace(traceIdHigh, traceIdLow, new Callback<List<Span>>(){

            public void onSuccess(@Nullable List<Span> value) {
                List result = CorrectForClockSkew.apply((List)MergeById.apply(value));
                callback.onSuccess((Object)(result.isEmpty() ? null : result));
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void getRawTrace(long traceId, Callback<List<Span>> callback) {
        this.getRawTrace(0L, traceId, callback);
    }

    public void getRawTrace(long traceIdHigh, long traceIdLow, Callback<List<Span>> callback) {
        String traceIdHex = Util.toLowerHex((long)(this.strictTraceId ? traceIdHigh : 0L), (long)traceIdLow);
        SearchRequest request = SearchRequest.create(Arrays.asList(this.allSpanIndices)).term("traceId", traceIdHex);
        this.search.newCall(request, BodyConverters.NULLABLE_SPANS).submit(callback);
    }

    public void getServiceNames(Callback<List<String>> callback) {
        long endMillis = System.currentTimeMillis();
        long beginMillis = endMillis - (long)this.namesLookback;
        List<String> indices = this.indexNameFormatter.formatTypeAndRange(SPAN, beginMillis, endMillis);
        SearchRequest.Filters filters = new SearchRequest.Filters();
        filters.addRange("timestamp_millis", beginMillis, endMillis);
        SearchRequest request = SearchRequest.create(indices).filters(filters).addAggregation(Aggregation.terms("localEndpoint.serviceName", Integer.MAX_VALUE)).addAggregation(Aggregation.terms("remoteEndpoint.serviceName", Integer.MAX_VALUE));
        this.search.newCall(request, BodyConverters.SORTED_KEYS).submit(callback);
    }

    public void getSpanNames(String serviceName, Callback<List<String>> callback) {
        if (serviceName == null || "".equals(serviceName)) {
            callback.onSuccess(Collections.emptyList());
            return;
        }
        long endMillis = System.currentTimeMillis();
        long beginMillis = endMillis - (long)this.namesLookback;
        List<String> indices = this.indexNameFormatter.formatTypeAndRange(SPAN, beginMillis, endMillis);
        SearchRequest.Filters filters = new SearchRequest.Filters().addRange("timestamp_millis", beginMillis, endMillis).addTerm("localEndpoint.serviceName", serviceName.toLowerCase(Locale.ROOT));
        SearchRequest request = SearchRequest.create(indices).filters(filters).addAggregation(Aggregation.terms("name", Integer.MAX_VALUE));
        this.search.newCall(request, BodyConverters.SORTED_KEYS).submit(callback);
    }

    public void getDependencies(long endTs, @Nullable Long lookback, Callback<List<DependencyLink>> callback) {
        long beginMillis = lookback != null ? endTs - lookback : 0L;
        List<String> indices = this.indexNameFormatter.formatTypeAndRange(DEPENDENCY, beginMillis, endTs);
        this.search.newCall(SearchRequest.create(indices), BodyConverters.DEPENDENCY_LINKS).submit(callback);
    }
}

