/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import zipkin.Annotation;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.internal.Nullable;
import zipkin.internal.Span2;
import zipkin.internal.Span2Codec;
import zipkin.internal.Span2Converter;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.Callback;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage;
import zipkin.storage.elasticsearch.http.HttpBulkIndexer;
import zipkin.storage.elasticsearch.http.IndexNameFormatter;

class ElasticsearchHttpSpanConsumer
implements AsyncSpanConsumer {
    static final Logger LOG = Logger.getLogger(ElasticsearchHttpSpanConsumer.class.getName());
    final ElasticsearchHttpStorage es;
    final IndexNameFormatter indexNameFormatter;

    ElasticsearchHttpSpanConsumer(ElasticsearchHttpStorage es) {
        this.es = es;
        this.indexNameFormatter = es.indexNameFormatter();
    }

    public void accept(List<Span> spans, Callback<Void> callback) {
        if (spans.isEmpty()) {
            callback.onSuccess(null);
            return;
        }
        try {
            BulkSpanIndexer indexer = this.newBulkSpanIndexer(this.es);
            this.indexSpans(indexer, spans);
            indexer.execute(callback);
        }
        catch (Throwable t) {
            Util.propagateIfFatal((Throwable)t);
            callback.onError(t);
        }
    }

    void indexSpans(BulkSpanIndexer indexer, List<Span> spans) throws IOException {
        for (Span span : spans) {
            Long spanTimestamp;
            Long timestamp = ApplyTimestampAndDuration.guessTimestamp((Span)span);
            long indexTimestamp = 0L;
            if (timestamp != null) {
                spanTimestamp = TimeUnit.MICROSECONDS.toMillis(timestamp);
                indexTimestamp = spanTimestamp;
            } else {
                spanTimestamp = null;
                int i = 0;
                int length = span.annotations.size();
                if (i < length) {
                    indexTimestamp = ((Annotation)span.annotations.get((int)i)).timestamp / 1000L;
                }
                if (indexTimestamp == 0L) {
                    indexTimestamp = System.currentTimeMillis();
                }
            }
            indexer.add(indexTimestamp, span, spanTimestamp);
        }
    }

    BulkSpanIndexer newBulkSpanIndexer(ElasticsearchHttpStorage es) {
        return new BulkSpanIndexer(es);
    }

    static byte[] prefixWithTimestampMillisAndQuery(Span2 span, @Nullable Long timestampMillis) {
        Buffer query = new Buffer();
        JsonWriter writer = JsonWriter.of((BufferedSink)query);
        try {
            writer.beginObject();
            if (timestampMillis != null) {
                writer.name("timestamp_millis").value((Number)timestampMillis);
            }
            if (!span.tags().isEmpty() || !span.annotations().isEmpty()) {
                writer.name("_q");
                writer.beginArray();
                for (Annotation annotation : span.annotations()) {
                    if (annotation.value.length() > 255) continue;
                    writer.value(annotation.value);
                }
                for (Map.Entry entry : span.tags().entrySet()) {
                    if (((String)entry.getKey()).length() + ((String)entry.getValue()).length() + 1 > 255) continue;
                    writer.value((String)entry.getKey());
                    writer.value((String)entry.getKey() + "=" + (String)entry.getValue());
                }
                writer.endArray();
            }
            writer.endObject();
        }
        catch (IOException e) {
            assert (false) : "Error indexing query for span: " + span;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Error indexing query for span: " + span, e);
            }
            return Span2Codec.JSON.writeSpan(span);
        }
        byte[] document = Span2Codec.JSON.writeSpan(span);
        if (query.rangeEquals(0L, ByteString.of((byte[])new byte[]{123, 125}))) {
            return document;
        }
        byte[] byArray = query.readByteArray();
        byte[] newSpanBytes = new byte[byArray.length + document.length - 1];
        int pos = 0;
        System.arraycopy(byArray, 0, newSpanBytes, pos, byArray.length);
        newSpanBytes[(pos += byArray.length) - 1] = 44;
        System.arraycopy(document, 1, newSpanBytes, pos, document.length - 1);
        return newSpanBytes;
    }

    static class BulkSpanIndexer {
        final HttpBulkIndexer indexer;
        final IndexNameFormatter indexNameFormatter;

        BulkSpanIndexer(ElasticsearchHttpStorage es) {
            this.indexer = new HttpBulkIndexer("index-span", es);
            this.indexNameFormatter = es.indexNameFormatter();
        }

        void add(long indexTimestamp, Span span, @Nullable Long timestampMillis) {
            String index = this.indexNameFormatter.formatTypeAndTimestamp("span", indexTimestamp);
            for (Span2 span2 : Span2Converter.fromSpan((Span)span)) {
                byte[] document = ElasticsearchHttpSpanConsumer.prefixWithTimestampMillisAndQuery(span2, timestampMillis);
                this.indexer.add(index, "span", document, null);
            }
        }

        void execute(Callback<Void> callback) throws IOException {
            this.indexer.execute(callback);
        }
    }
}

