/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import zipkin.internal.Nullable;
import zipkin.storage.elasticsearch.http.IndexTemplates;

final class AutoValue_IndexTemplates
extends IndexTemplates {
    private final float version;
    private final String legacy;
    private final String span;
    private final String dependency;

    private AutoValue_IndexTemplates(float version, @Nullable String legacy, String span, String dependency) {
        this.version = version;
        this.legacy = legacy;
        this.span = span;
        this.dependency = dependency;
    }

    @Override
    float version() {
        return this.version;
    }

    @Override
    @Nullable
    String legacy() {
        return this.legacy;
    }

    @Override
    String span() {
        return this.span;
    }

    @Override
    String dependency() {
        return this.dependency;
    }

    public String toString() {
        return "IndexTemplates{version=" + this.version + ", legacy=" + this.legacy + ", span=" + this.span + ", dependency=" + this.dependency + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexTemplates) {
            IndexTemplates that = (IndexTemplates)o;
            return Float.floatToIntBits(this.version) == Float.floatToIntBits(that.version()) && (this.legacy == null ? that.legacy() == null : this.legacy.equals(that.legacy())) && this.span.equals(that.span()) && this.dependency.equals(that.dependency());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Float.floatToIntBits(this.version);
        h *= 1000003;
        h ^= this.legacy == null ? 0 : this.legacy.hashCode();
        h *= 1000003;
        h ^= this.span.hashCode();
        h *= 1000003;
        return h ^= this.dependency.hashCode();
    }

    static final class Builder
    implements IndexTemplates.Builder {
        private Float version;
        private String legacy;
        private String span;
        private String dependency;

        Builder() {
        }

        @Override
        public IndexTemplates.Builder version(float version) {
            this.version = Float.valueOf(version);
            return this;
        }

        @Override
        public IndexTemplates.Builder legacy(@Nullable String legacy) {
            this.legacy = legacy;
            return this;
        }

        @Override
        public IndexTemplates.Builder span(String span) {
            if (span == null) {
                throw new NullPointerException("Null span");
            }
            this.span = span;
            return this;
        }

        @Override
        public IndexTemplates.Builder dependency(String dependency) {
            if (dependency == null) {
                throw new NullPointerException("Null dependency");
            }
            this.dependency = dependency;
            return this;
        }

        @Override
        public IndexTemplates build() {
            String missing = "";
            if (this.version == null) {
                missing = missing + " version";
            }
            if (this.span == null) {
                missing = missing + " span";
            }
            if (this.dependency == null) {
                missing = missing + " dependency";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_IndexTemplates(this.version.floatValue(), this.legacy, this.span, this.dependency);
        }
    }
}

