/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import zipkin.internal.Nullable;
import zipkin.internal.Util;

final class PseudoAddressRecordSet {
    private static final int IPV4_PART_COUNT = 4;
    private static final int IPV6_PART_COUNT = 8;

    PseudoAddressRecordSet() {
    }

    static Dns create(List<String> urls, Dns actualDns) {
        LinkedHashSet<String> schemes = new LinkedHashSet<String>();
        LinkedHashSet<String> hosts = new LinkedHashSet<String>();
        LinkedHashSet<InetAddress> ipAddresses = new LinkedHashSet<InetAddress>();
        LinkedHashSet<Integer> ports = new LinkedHashSet<Integer>();
        for (String url : urls) {
            HttpUrl httpUrl = HttpUrl.parse((String)url);
            schemes.add(httpUrl.scheme());
            byte[] addressBytes = null;
            try {
                addressBytes = PseudoAddressRecordSet.ipStringToBytes(httpUrl.host());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (addressBytes != null) {
                try {
                    ipAddresses.add(InetAddress.getByAddress(addressBytes));
                }
                catch (UnknownHostException e) {
                    hosts.add(httpUrl.host());
                }
            } else {
                hosts.add(httpUrl.host());
            }
            ports.add(httpUrl.port());
        }
        Util.checkArgument((ports.size() == 1 ? 1 : 0) != 0, (String)"Only one port supported with multiple hosts %s", (Object[])new Object[]{urls});
        Util.checkArgument((schemes.size() == 1 && ((String)schemes.iterator().next()).equals("http") ? 1 : 0) != 0, (String)"Only http supported with multiple hosts %s", (Object[])new Object[]{urls});
        if (hosts.isEmpty()) {
            return new StaticDns(ipAddresses);
        }
        return new ConcatenatingDns(ipAddresses, hosts, actualDns);
    }

    @Nullable
    static byte[] ipStringToBytes(String ipString) {
        if (ipString == null || ipString.isEmpty()) {
            return null;
        }
        boolean hasColon = false;
        boolean hasDot = false;
        for (int i = 0; i < ipString.length(); ++i) {
            char c = ipString.charAt(i);
            if (c == '.') {
                hasDot = true;
                continue;
            }
            if (c == ':') {
                if (hasDot) {
                    return null;
                }
                hasColon = true;
                continue;
            }
            if (Character.digit(c, 16) != -1) continue;
            return null;
        }
        if (hasColon) {
            if (hasDot && (ipString = PseudoAddressRecordSet.convertDottedQuadToHex(ipString)) == null) {
                return null;
            }
            return PseudoAddressRecordSet.textToNumericFormatV6(ipString);
        }
        if (hasDot) {
            return PseudoAddressRecordSet.textToNumericFormatV4(ipString);
        }
        return null;
    }

    @Nullable
    private static byte[] textToNumericFormatV4(String ipString) {
        byte[] bytes = new byte[4];
        int i = 0;
        try {
            for (String octet : ipString.split("\\.", 5)) {
                bytes[i++] = PseudoAddressRecordSet.parseOctet(octet);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return (byte[])(i == 4 ? bytes : null);
    }

    @Nullable
    private static byte[] textToNumericFormatV6(String ipString) {
        int partsLo;
        int partsHi;
        String[] parts = ipString.split(":", 10);
        if (parts.length < 3 || parts.length > 9) {
            return null;
        }
        int skipIndex = -1;
        for (int i = 1; i < parts.length - 1; ++i) {
            if (parts[i].length() != 0) continue;
            if (skipIndex >= 0) {
                return null;
            }
            skipIndex = i;
        }
        if (skipIndex >= 0) {
            partsHi = skipIndex;
            partsLo = parts.length - skipIndex - 1;
            if (parts[0].length() == 0 && --partsHi != 0) {
                return null;
            }
            if (parts[parts.length - 1].length() == 0 && --partsLo != 0) {
                return null;
            }
        } else {
            partsHi = parts.length;
            partsLo = 0;
        }
        int partsSkipped = 8 - (partsHi + partsLo);
        if (!(skipIndex < 0 ? partsSkipped == 0 : partsSkipped >= 1)) {
            return null;
        }
        ByteBuffer rawBytes = ByteBuffer.allocate(16);
        try {
            int i;
            for (i = 0; i < partsHi; ++i) {
                rawBytes.putShort(PseudoAddressRecordSet.parseHextet(parts[i]));
            }
            for (i = 0; i < partsSkipped; ++i) {
                rawBytes.putShort((short)0);
            }
            for (i = partsLo; i > 0; --i) {
                rawBytes.putShort(PseudoAddressRecordSet.parseHextet(parts[parts.length - i]));
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return rawBytes.array();
    }

    @Nullable
    private static String convertDottedQuadToHex(String ipString) {
        int lastColon = ipString.lastIndexOf(58);
        String initialPart = ipString.substring(0, lastColon + 1);
        String dottedQuad = ipString.substring(lastColon + 1);
        byte[] quad = PseudoAddressRecordSet.textToNumericFormatV4(dottedQuad);
        if (quad == null) {
            return null;
        }
        String penultimate = Integer.toHexString((quad[0] & 0xFF) << 8 | quad[1] & 0xFF);
        String ultimate = Integer.toHexString((quad[2] & 0xFF) << 8 | quad[3] & 0xFF);
        return initialPart + penultimate + ":" + ultimate;
    }

    private static byte parseOctet(String ipPart) {
        int octet = Integer.parseInt(ipPart);
        if (octet > 255 || ipPart.startsWith("0") && ipPart.length() > 1) {
            throw new NumberFormatException();
        }
        return (byte)octet;
    }

    private static short parseHextet(String ipPart) {
        int hextet = Integer.parseInt(ipPart, 16);
        if (hextet > 65535) {
            throw new NumberFormatException();
        }
        return (short)hextet;
    }

    static final class ConcatenatingDns
    implements Dns {
        final Set<InetAddress> ipAddresses;
        final Set<String> hosts;
        final Dns actualDns;

        ConcatenatingDns(Set<InetAddress> ipAddresses, Set<String> hosts, Dns actualDns) {
            this.ipAddresses = ipAddresses;
            this.hosts = hosts;
            this.actualDns = actualDns;
        }

        public List<InetAddress> lookup(String hostname) throws UnknownHostException {
            ArrayList<InetAddress> result = new ArrayList<InetAddress>(this.ipAddresses.size() + this.hosts.size());
            result.addAll(this.ipAddresses);
            for (String host : this.hosts) {
                result.addAll(this.actualDns.lookup(host));
            }
            return result;
        }

        public String toString() {
            return "ConcatenatingDns(" + this.ipAddresses + "," + this.hosts + ")";
        }
    }

    static final class StaticDns
    implements Dns {
        private final List<InetAddress> ipAddresses;

        StaticDns(Set<InetAddress> ipAddresses) {
            this.ipAddresses = new ArrayList<InetAddress>(ipAddresses);
        }

        public List<InetAddress> lookup(String hostname) {
            return this.ipAddresses;
        }

        public String toString() {
            return "StaticDns(" + this.ipAddresses + ")";
        }
    }
}

