/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.internal.brave;

import brave.Tracer;
import brave.Tracing;
import java.io.IOException;
import java.util.List;
import zipkin.server.internal.brave.TracedCall;
import zipkin2.Call;
import zipkin2.DependencyLink;
import zipkin2.Span;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;

public final class TracingStorageComponent
extends StorageComponent {
    final Tracing tracing;
    final StorageComponent delegate;

    public TracingStorageComponent(Tracing tracing, StorageComponent delegate) {
        this.tracing = tracing;
        this.delegate = delegate;
    }

    public SpanStore spanStore() {
        return new TracingSpanStore(this.tracing, this.delegate.spanStore());
    }

    public SpanConsumer spanConsumer() {
        return this.delegate.spanConsumer();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    static final class TracingSpanStore
    implements SpanStore {
        private final Tracer tracer;
        private final SpanStore delegate;

        TracingSpanStore(Tracing tracing, SpanStore delegate) {
            this.tracer = tracing.tracer();
            this.delegate = delegate;
        }

        public Call<List<List<Span>>> getTraces(QueryRequest request) {
            return new TracedCall<List<List<Span>>>(this.tracer, this.delegate.getTraces(request), "get-traces");
        }

        public Call<List<Span>> getTrace(String traceId) {
            return new TracedCall<List<Span>>(this.tracer, this.delegate.getTrace(traceId), "get-trace");
        }

        public Call<List<String>> getServiceNames() {
            return new TracedCall<List<String>>(this.tracer, this.delegate.getServiceNames(), "get-service-names");
        }

        public Call<List<String>> getSpanNames(String serviceName) {
            return new TracedCall<List<String>>(this.tracer, this.delegate.getSpanNames(serviceName), "get-span-names");
        }

        public Call<List<DependencyLink>> getDependencies(long endTs, long lookback) {
            return new TracedCall<List<DependencyLink>>(this.tracer, this.delegate.getDependencies(endTs, lookback), "get-dependencies");
        }
    }
}

