/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.internal.brave;

import brave.Span;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ExceptionHandler;
import io.undertow.util.HeaderMap;
import java.net.InetSocketAddress;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin.server.internal.ConditionalOnSelfTracing;
import zipkin2.Endpoint;

@ConditionalOnSelfTracing
@Configuration
public class TracingHttpHandlerConfiguration {
    @Bean
    @Qualifier(value="httpTracingCustomizer")
    UndertowDeploymentInfoCustomizer httpTracingCustomizer(HttpTracing httpTracing) {
        TracingHttpHandler.Wrapper result = new TracingHttpHandler.Wrapper(httpTracing);
        return info -> info.addInitialHandlerChainWrapper((HandlerWrapper)result);
    }

    static final class Adapter
    extends HttpServerAdapter<HttpServerExchange, HttpServerExchange> {
        Adapter() {
        }

        public String method(HttpServerExchange request) {
            return request.getRequestMethod().toString();
        }

        public String path(HttpServerExchange request) {
            return request.getRequestPath();
        }

        public String url(HttpServerExchange request) {
            return request.getRequestURL();
        }

        public String requestHeader(HttpServerExchange request, String name) {
            return request.getRequestHeaders().getFirst(name);
        }

        public Integer statusCode(HttpServerExchange response) {
            return response.getStatusCode();
        }

        public boolean parseClientAddress(HttpServerExchange req, Endpoint.Builder builder) {
            if (super.parseClientAddress((Object)req, builder)) {
                return true;
            }
            InetSocketAddress addr = (InetSocketAddress)req.getConnection().getPeerAddress();
            if (builder.parseIp(addr.getAddress())) {
                builder.port(Integer.valueOf(addr.getPort()));
                return true;
            }
            return false;
        }
    }

    static final class TracingHttpHandler
    implements HttpHandler {
        static final Propagation.Getter<HeaderMap, String> GETTER = new Propagation.Getter<HeaderMap, String>(){

            public String get(HeaderMap carrier, String key) {
                return carrier.getFirst(key);
            }

            public String toString() {
                return "HttpServerRequest::getHeader";
            }
        };
        final CurrentTraceContext currentTraceContext;
        final HttpServerHandler<HttpServerExchange, HttpServerExchange> serverHandler;
        final TraceContext.Extractor<HeaderMap> extractor;
        final HttpHandler next;

        TracingHttpHandler(HttpTracing httpTracing, HttpHandler next) {
            this.currentTraceContext = httpTracing.tracing().currentTraceContext();
            this.serverHandler = HttpServerHandler.create((HttpTracing)httpTracing, (HttpServerAdapter)new Adapter());
            this.extractor = httpTracing.tracing().propagation().extractor(GETTER);
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            block15: {
                if (!exchange.isComplete()) {
                    Span span = this.serverHandler.handleReceive(this.extractor, (Object)exchange.getRequestHeaders(), (Object)exchange);
                    exchange.addExchangeCompleteListener((exch, nextListener) -> {
                        try {
                            nextListener.proceed();
                        }
                        finally {
                            this.serverHandler.handleSend((Object)exch, (Throwable)exch.getAttachment(ExceptionHandler.THROWABLE), span);
                        }
                    });
                    try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(span.context());){
                        this.next.handleRequest(exchange);
                        break block15;
                    }
                    catch (Error | Exception e) {
                        exchange.putAttachment(ExceptionHandler.THROWABLE, (Object)e);
                        throw e;
                    }
                }
                this.next.handleRequest(exchange);
            }
        }

        static final class Wrapper
        implements HandlerWrapper {
            final HttpTracing httpTracing;

            Wrapper(HttpTracing httpTracing) {
                this.httpTracing = httpTracing;
            }

            public HttpHandler wrap(HttpHandler next) {
                return new TracingHttpHandler(this.httpTracing, next);
            }
        }
    }
}

