/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.RequestConverter;
import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import zipkin2.Callback;
import zipkin2.Span;
import zipkin2.SpanBytesDecoderDetector;
import zipkin2.codec.BytesDecoder;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.server.internal.BodyIsExceptionMessage;
import zipkin2.server.internal.CompletableCallback;
import zipkin2.server.internal.ConsumesProtobuf;
import zipkin2.server.internal.ConsumesThrift;
import zipkin2.server.internal.UnzippingBytesRequestConverter;
import zipkin2.storage.StorageComponent;

@ConditionalOnProperty(name={"zipkin.collector.http.enabled"}, matchIfMissing=true)
@RequestConverter(value=UnzippingBytesRequestConverter.class)
@ExceptionHandler(value=BodyIsExceptionMessage.class)
public class ZipkinHttpCollector {
    static volatile CollectorMetrics metrics;
    final Collector collector;

    ZipkinHttpCollector(StorageComponent storage, CollectorSampler sampler, CollectorMetrics metrics) {
        metrics = metrics.forTransport("http");
        this.collector = Collector.newBuilder(this.getClass()).storage(storage).sampler(sampler).metrics(metrics).build();
        ZipkinHttpCollector.metrics = metrics;
    }

    @Post(value="/api/v2/spans")
    public HttpResponse uploadSpans(byte[] serializedSpans) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V2, serializedSpans);
    }

    @Post(value="/api/v2/spans")
    @ConsumesJson
    public HttpResponse uploadSpansJson(byte[] serializedSpans) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V2, serializedSpans);
    }

    @Post(value="/api/v2/spans")
    @ConsumesProtobuf
    public HttpResponse uploadSpansProtobuf(byte[] serializedSpans) {
        return this.validateAndStoreSpans(SpanBytesDecoder.PROTO3, serializedSpans);
    }

    @Post(value="/api/v1/spans")
    public HttpResponse uploadSpansV1(byte[] serializedSpans) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V1, serializedSpans);
    }

    @Post(value="/api/v1/spans")
    @ConsumesJson
    public HttpResponse uploadSpansV1Json(byte[] serializedSpans) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V1, serializedSpans);
    }

    @Post(value="/api/v1/spans")
    @ConsumesThrift
    public HttpResponse uploadSpansV1Thrift(byte[] serializedSpans) {
        return this.validateAndStoreSpans(SpanBytesDecoder.THRIFT, serializedSpans);
    }

    HttpResponse validateAndStoreSpans(SpanBytesDecoder decoder, byte[] serializedSpans) {
        try {
            SpanBytesDecoderDetector.decoderForListMessage((byte[])serializedSpans);
        }
        catch (IllegalArgumentException e) {
            metrics.incrementMessagesDropped();
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Expected a " + decoder + " encoded list\n"));
        }
        SpanBytesDecoder unexpectedDecoder = BodyIsExceptionMessage.testForUnexpectedFormat((BytesDecoder<Span>)decoder, serializedSpans);
        if (unexpectedDecoder != null) {
            metrics.incrementMessagesDropped();
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Expected a " + decoder + " encoded list, but received: " + unexpectedDecoder + "\n"));
        }
        CompletableCallback result = new CompletableCallback();
        ArrayList spans = new ArrayList();
        if (!decoder.decodeList(serializedSpans, spans)) {
            throw new IllegalArgumentException("Empty " + decoder.name() + " message");
        }
        this.collector.accept(spans, (Callback)result);
        return HttpResponse.from((CompletionStage)result);
    }
}

