/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import zipkin2.Call;
import zipkin2.Span;
import zipkin2.codec.DependencyLinkBytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.internal.Nullable;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.StorageComponent;

@RestController
@RequestMapping(value={"/api/v2"})
@ConditionalOnProperty(name={"zipkin.query.enabled"}, matchIfMissing=true)
public class ZipkinQueryApiV2 {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    final String storageType;
    final StorageComponent storage;
    final long defaultLookback;
    final int namesMaxAge;
    final List<String> autocompleteKeys;
    volatile int serviceCount;

    ZipkinQueryApiV2(StorageComponent storage, @Value(value="${zipkin.storage.type:mem}") String storageType, @Value(value="${zipkin.query.lookback:86400000}") long defaultLookback, @Value(value="${zipkin.query.names-max-age:300}") int namesMaxAge, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys) {
        this.storage = storage;
        this.storageType = storageType;
        this.defaultLookback = defaultLookback;
        this.namesMaxAge = namesMaxAge;
        this.autocompleteKeys = autocompleteKeys;
    }

    @RequestMapping(value={"/dependencies"}, method={RequestMethod.GET}, produces={"application/json"})
    public byte[] getDependencies(@RequestParam(value="endTs", required=true) long endTs, @Nullable @RequestParam(value="lookback", required=false) Long lookback) throws IOException {
        Call call = this.storage.spanStore().getDependencies(endTs, lookback != null ? lookback : this.defaultLookback);
        return DependencyLinkBytesEncoder.JSON_V1.encodeList((List)call.execute());
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> getServiceNames() throws IOException {
        List serviceNames = (List)this.storage.spanStore().getServiceNames().execute();
        this.serviceCount = serviceNames.size();
        return this.maybeCacheNames(serviceNames);
    }

    @RequestMapping(value={"/spans"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> getSpanNames(@RequestParam(value="serviceName") String serviceName) throws IOException {
        return this.maybeCacheNames((List)this.storage.spanStore().getSpanNames(serviceName).execute());
    }

    @RequestMapping(value={"/traces"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getTraces(@Nullable @RequestParam(value="serviceName", required=false) String serviceName, @Nullable @RequestParam(value="spanName", required=false) String spanName, @Nullable @RequestParam(value="annotationQuery", required=false) String annotationQuery, @Nullable @RequestParam(value="minDuration", required=false) Long minDuration, @Nullable @RequestParam(value="maxDuration", required=false) Long maxDuration, @Nullable @RequestParam(value="endTs", required=false) Long endTs, @Nullable @RequestParam(value="lookback", required=false) Long lookback, @RequestParam(value="limit", defaultValue="10") int limit) throws IOException {
        QueryRequest queryRequest = QueryRequest.newBuilder().serviceName(serviceName).spanName(spanName).parseAnnotationQuery(annotationQuery).minDuration(minDuration).maxDuration(maxDuration).endTs(endTs != null ? endTs : System.currentTimeMillis()).lookback(lookback != null ? lookback : this.defaultLookback).limit(limit).build();
        List traces = (List)this.storage.spanStore().getTraces(queryRequest).execute();
        return new String(ZipkinQueryApiV2.writeTraces(SpanBytesEncoder.JSON_V2, traces), UTF_8);
    }

    @RequestMapping(value={"/trace/{traceIdHex}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getTrace(@PathVariable String traceIdHex, WebRequest request) throws IOException {
        List trace = (List)this.storage.spanStore().getTrace(traceIdHex).execute();
        if (trace.isEmpty()) {
            throw new TraceNotFoundException(traceIdHex);
        }
        return new String(SpanBytesEncoder.JSON_V2.encodeList(trace), UTF_8);
    }

    @GetMapping(value={"/autocompleteKeys"}, produces={"application/json"})
    public ResponseEntity<List<String>> getAutocompleteKeys() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)this.namesMaxAge, (TimeUnit)TimeUnit.SECONDS).mustRevalidate())).body(this.autocompleteKeys);
    }

    @GetMapping(value={"/autocompleteValues"}, produces={"application/json"})
    public ResponseEntity<List<String>> getAutocompleteValues(@RequestParam String key) throws IOException {
        return this.maybeCacheAutocompleteValues((List)this.storage.autocompleteTags().getValues(key).execute());
    }

    ResponseEntity<List<String>> maybeCacheAutocompleteValues(List<String> values) {
        ResponseEntity.BodyBuilder response = ResponseEntity.ok();
        if (values.size() > 3) {
            response.cacheControl(CacheControl.maxAge((long)this.namesMaxAge, (TimeUnit)TimeUnit.SECONDS).mustRevalidate());
        }
        return response.body(values);
    }

    @ExceptionHandler(value={TraceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void notFound() {
    }

    ResponseEntity<List<String>> maybeCacheNames(List<String> names) {
        ResponseEntity.BodyBuilder response = ResponseEntity.ok();
        if (this.serviceCount > 3) {
            response.cacheControl(CacheControl.maxAge((long)this.namesMaxAge, (TimeUnit)TimeUnit.SECONDS).mustRevalidate());
        }
        return response.body(names);
    }

    static byte[] writeTraces(SpanBytesEncoder codec, List<List<Span>> traces) {
        int length = traces.size();
        int sizeInBytes = 2;
        if (length > 1) {
            sizeInBytes += length - 1;
        }
        for (int i = 0; i < length; ++i) {
            List<Span> spans = traces.get(i);
            int jLength = spans.size();
            sizeInBytes += 2;
            if (jLength > 1) {
                sizeInBytes += jLength - 1;
            }
            for (int j = 0; j < jLength; ++j) {
                sizeInBytes += codec.sizeInBytes((Object)spans.get(j));
            }
        }
        byte[] out = new byte[sizeInBytes];
        int pos = 0;
        out[pos++] = 91;
        for (int i = 0; i < length; ++i) {
            pos += codec.encodeList(traces.get(i), out, pos);
            if (i + 1 >= length) continue;
            out[pos++] = 44;
        }
        out[pos] = 93;
        return out;
    }

    static class TraceNotFoundException
    extends RuntimeException {
        TraceNotFoundException(String traceIdHex) {
            super("Cannot find trace " + traceIdHex);
        }
    }
}

