/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.buffer.BufferMetricReader;
import org.springframework.boot.actuate.metrics.buffer.CounterBuffers;
import org.springframework.boot.actuate.metrics.buffer.GaugeBuffers;
import zipkin.collector.CollectorMetrics;
import zipkin.internal.Nullable;
import zipkin.internal.Util;

public final class ActuateCollectorMetrics
implements CollectorMetrics,
PublicMetrics {
    private final CounterBuffers counterBuffers;
    private final GaugeBuffers gaugeBuffers;
    private final String messages;
    private final String messagesDropped;
    private final String messageBytes;
    private final String messageSpans;
    private final String bytes;
    private final String spans;
    private final String spansDropped;
    private final BufferMetricReader reader;

    public ActuateCollectorMetrics(CounterBuffers counterBuffers, GaugeBuffers gaugeBuffers) {
        this(counterBuffers, gaugeBuffers, null);
    }

    ActuateCollectorMetrics(CounterBuffers counterBuffers, GaugeBuffers gaugeBuffers, @Nullable String transport) {
        this.counterBuffers = counterBuffers;
        this.gaugeBuffers = gaugeBuffers;
        this.reader = new BufferMetricReader(counterBuffers, gaugeBuffers);
        String footer = transport == null ? "" : "." + transport;
        this.messages = "counter.zipkin_collector.messages" + footer;
        this.messagesDropped = "counter.zipkin_collector.messages_dropped" + footer;
        this.messageBytes = "gauge.zipkin_collector.message_bytes" + footer;
        this.messageSpans = "gauge.zipkin_collector.message_spans" + footer;
        this.bytes = "counter.zipkin_collector.bytes" + footer;
        this.spans = "counter.zipkin_collector.spans" + footer;
        this.spansDropped = "counter.zipkin_collector.spans_dropped" + footer;
    }

    public ActuateCollectorMetrics forTransport(String transportType) {
        Util.checkNotNull((Object)transportType, (String)"transportType");
        return new ActuateCollectorMetrics(this.counterBuffers, this.gaugeBuffers, transportType);
    }

    public Collection<Metric<?>> metrics() {
        Iterable metrics = this.reader.findAll();
        ArrayList result = new ArrayList();
        metrics.forEach(result::add);
        return result;
    }

    public void incrementMessages() {
        this.counterBuffers.increment(this.messages, 1L);
    }

    public void incrementMessagesDropped() {
        this.counterBuffers.increment(this.messagesDropped, 1L);
    }

    public void incrementSpans(int quantity) {
        this.gaugeBuffers.set(this.messageSpans, (double)quantity);
        this.counterBuffers.increment(this.spans, (long)quantity);
    }

    public void incrementBytes(int quantity) {
        this.gaugeBuffers.set(this.messageBytes, (double)quantity);
        this.counterBuffers.increment(this.bytes, (long)quantity);
    }

    public void incrementSpansDropped(int quantity) {
        this.counterBuffers.increment(this.spansDropped, (long)quantity);
    }

    void reset() {
        this.counterBuffers.reset(this.messages);
        this.counterBuffers.reset(this.messagesDropped);
        this.counterBuffers.reset(this.bytes);
        this.counterBuffers.reset(this.spans);
        this.counterBuffers.reset(this.spansDropped);
        this.gaugeBuffers.set(this.messageSpans, 0.0);
        this.gaugeBuffers.set(this.messageBytes, 0.0);
    }
}

