/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import com.github.kristofa.brave.AbstractSpanCollector;
import com.github.kristofa.brave.EmptySpanCollectorMetricsHandler;
import com.github.kristofa.brave.SpanCollectorMetricsHandler;
import com.twitter.zipkin.gen.SpanCodec;
import zipkin.Codec;
import zipkin.collector.Collector;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.storage.Callback;
import zipkin.storage.StorageComponent;

public class LocalSpanCollector
extends AbstractSpanCollector {
    private final CollectorMetrics metrics;
    private final Collector collector;

    public LocalSpanCollector(StorageComponent storage, int flushInterval, CollectorSampler sampler, CollectorMetrics metrics) {
        super(SpanCodec.THRIFT, (SpanCollectorMetricsHandler)new EmptySpanCollectorMetricsHandler(), LocalSpanCollector.checkPositive(flushInterval));
        this.metrics = metrics.forTransport("local");
        this.collector = Collector.builder(((Object)((Object)this)).getClass()).storage(storage).sampler(sampler).metrics(this.metrics).build();
    }

    private static int checkPositive(int flushInterval) {
        if (flushInterval <= 0) {
            throw new IllegalArgumentException("flushInterval must be a positive duration in seconds");
        }
        return flushInterval;
    }

    protected void sendSpans(byte[] thrift) {
        this.metrics.incrementMessages();
        this.collector.acceptSpans(thrift, (Codec)Codec.THRIFT, Callback.NOOP);
    }
}

