/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.ThreadLocalServerClientAndLocalSpanState;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import zipkin.Endpoint;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.server.ConditionalOnSelfTracing;
import zipkin.server.brave.ApiTracerConfiguration;
import zipkin.server.brave.LocalSpanCollector;
import zipkin.storage.StorageComponent;

@Configuration
@ConditionalOnSelfTracing
@Import(value={ApiTracerConfiguration.class})
public class BraveConfiguration {
    @Bean
    @Scope
    Endpoint local(@Value(value="${server.port:9411}") int port) {
        int ipv4;
        try {
            ipv4 = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().flatMap(i -> Collections.list(i.getInetAddresses()).stream()).filter(ip -> ip instanceof Inet4Address && ip.isSiteLocalAddress()).map(InetAddress::getAddress).map(bytes -> new BigInteger((byte[])bytes).intValue()).findAny().get();
        }
        catch (Exception ignored) {
            ipv4 = 2130706433;
        }
        return Endpoint.create((String)"zipkin-server", (int)ipv4, (int)port);
    }

    @Bean
    LocalSpanCollector spanCollector(StorageComponent storage, @Value(value="${zipkin.self-tracing.flush-interval:1}") int flushInterval, CollectorSampler sampler, CollectorMetrics metrics) {
        return new LocalSpanCollector(storage, flushInterval, sampler, metrics);
    }

    @Bean
    ServerClientAndLocalSpanState braveState(@Qualifier(value="local") Endpoint localEndpoint) {
        return new ThreadLocalServerClientAndLocalSpanState(localEndpoint.ipv4, (int)localEndpoint.port.shortValue(), localEndpoint.serviceName);
    }

    @Bean
    Brave brave(ServerClientAndLocalSpanState braveState, LocalSpanCollector spanCollector) {
        return new Brave.Builder(braveState).spanCollector((SpanCollector)spanCollector).build();
    }
}

