/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch.http.brave;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpTracing;
import brave.okhttp3.TracingInterceptor;
import brave.propagation.CurrentTraceContext;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@ConditionalOnBean(value={Tracing.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="elasticsearch")
@Configuration
public class TracingZipkinElasticsearchHttpStorageAutoConfiguration {
    @Autowired
    @Lazy
    HttpTracing httpTracing;

    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    @ConditionalOnMissingBean
    OkHttpClient.Builder elasticsearchOkHttpClientBuilder() {
        ExecutorService tracingExecutor = this.httpTracing.tracing().currentTraceContext().executorService(new Dispatcher().executorService());
        final Tracer tracer = this.httpTracing.tracing().tracer();
        final CurrentTraceContext currentTraceContext = this.httpTracing.tracing().currentTraceContext();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor(new Interceptor(){

            /*
             * Loose catch block
             */
            public Response intercept(Interceptor.Chain chain) throws IOException {
                if (currentTraceContext.get() == null) {
                    return chain.proceed(chain.request());
                }
                Request request = chain.request();
                Span span = tracer.nextSpan().name(request.tag().toString());
                try {
                    try (Tracer.SpanInScope ws = tracer.withSpanInScope(span.start());){
                        Response response = chain.proceed(request);
                        return response;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    span.finish();
                }
            }
        });
        builder.addNetworkInterceptor(TracingInterceptor.create((HttpTracing)this.httpTracing.clientOf("elasticsearch")));
        builder.dispatcher(new Dispatcher(tracingExecutor));
        return builder;
    }
}

