/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch.http;

import java.util.logging.Logger;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin.autoconfigure.storage.elasticsearch.http.BasicAuthInterceptor;
import zipkin.autoconfigure.storage.elasticsearch.http.ZipkinElasticsearchHttpStorageAutoConfiguration$$Lambda$1;
import zipkin.autoconfigure.storage.elasticsearch.http.ZipkinElasticsearchHttpStorageProperties;
import zipkin.internal.V2StorageComponent;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage;
import zipkin2.storage.StorageComponent;

@Configuration
@EnableConfigurationProperties(value={ZipkinElasticsearchHttpStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="elasticsearch")
@ConditionalOnMissingBean(value={zipkin.storage.StorageComponent.class})
public class ZipkinElasticsearchHttpStorageAutoConfiguration {
    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    @Conditional(value={HttpLoggingSet.class})
    Interceptor loggingInterceptor(ZipkinElasticsearchHttpStorageProperties es) {
        Logger logger = Logger.getLogger(ElasticsearchHttpStorage.class.getName());
        return new HttpLoggingInterceptor(ZipkinElasticsearchHttpStorageAutoConfiguration$$Lambda$1.lambdaFactory$(logger)).setLevel(es.getHttpLogging());
    }

    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    @Conditional(value={BasicAuthRequired.class})
    Interceptor basicAuthInterceptor(ZipkinElasticsearchHttpStorageProperties es) {
        return new BasicAuthInterceptor(es);
    }

    @Bean
    @ConditionalOnMissingBean
    V2StorageComponent storage(ElasticsearchHttpStorage.Builder esHttpBuilder) {
        return V2StorageComponent.create((StorageComponent)esHttpBuilder.build());
    }

    @Bean
    ElasticsearchHttpStorage v2Storage(V2StorageComponent component) {
        return (ElasticsearchHttpStorage)component.delegate();
    }

    @Bean
    ElasticsearchHttpStorage.Builder esHttpBuilder(ZipkinElasticsearchHttpStorageProperties elasticsearch, @Qualifier(value="zipkinElasticsearchHttp") OkHttpClient client, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.query.lookback:86400000}") int namesLookback) {
        return elasticsearch.toBuilder(client).strictTraceId(strictTraceId).namesLookback(namesLookback);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    static /* synthetic */ void lambda$loggingInterceptor$0(Logger logger, String message) {
        logger.info(message);
    }

    static final class BasicAuthRequired
    implements Condition {
        BasicAuthRequired() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            String userName = condition.getEnvironment().getProperty("zipkin.storage.elasticsearch.username");
            String password = condition.getEnvironment().getProperty("zipkin.storage.elasticsearch.password");
            return !ZipkinElasticsearchHttpStorageAutoConfiguration.isEmpty(userName) && !ZipkinElasticsearchHttpStorageAutoConfiguration.isEmpty(password);
        }
    }

    static final class HttpLoggingSet
    implements Condition {
        HttpLoggingSet() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            return !ZipkinElasticsearchHttpStorageAutoConfiguration.isEmpty(condition.getEnvironment().getProperty("zipkin.storage.elasticsearch.http-logging"));
        }
    }
}

