/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch.http;

import java.util.Collections;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="elasticsearch")
public class ZipkinElasticsearchOkHttpAutoConfiguration {
    @Autowired(required=false)
    @Qualifier(value="zipkinElasticsearchHttp")
    List<Interceptor> networkInterceptors = Collections.emptyList();
    @Autowired(required=false)
    @Qualifier(value="zipkinElasticsearchHttp")
    OkHttpClient.Builder elasticsearchOkHttpClientBuilder;

    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    @ConditionalOnMissingBean
    OkHttpClient elasticsearchOkHttpClient() {
        OkHttpClient.Builder builder = this.elasticsearchOkHttpClientBuilder != null ? this.elasticsearchOkHttpClientBuilder : new OkHttpClient.Builder();
        for (Interceptor interceptor : this.networkInterceptors) {
            builder.addNetworkInterceptor(interceptor);
        }
        return builder.build();
    }
}

