/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.autoconfigure.collector.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import zipkin2.collector.rabbitmq.RabbitMQCollector;

@ConfigurationProperties(value="zipkin.collector.rabbitmq")
class ZipkinRabbitMQCollectorProperties {
    static final URI EMPTY_URI = URI.create("");
    private List<String> addresses;
    private Integer concurrency = 1;
    private Integer connectionTimeout;
    private String password;
    private String queue;
    private String username;
    private String virtualHost;
    private Boolean useSsl;
    private URI uri;

    ZipkinRabbitMQCollectorProperties() {
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public Boolean getUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        if (EMPTY_URI.equals(uri)) {
            return;
        }
        this.uri = uri;
    }

    public RabbitMQCollector.Builder toBuilder() throws KeyManagementException, NoSuchAlgorithmException, URISyntaxException {
        RabbitMQCollector.Builder result = RabbitMQCollector.builder();
        ConnectionFactory connectionFactory = new ConnectionFactory();
        if (this.concurrency != null) {
            result.concurrency(this.concurrency.intValue());
        }
        if (this.connectionTimeout != null) {
            connectionFactory.setConnectionTimeout(this.connectionTimeout.intValue());
        }
        if (this.queue != null) {
            result.queue(this.queue);
        }
        if (this.uri != null) {
            connectionFactory.setUri(this.uri);
        } else {
            if (this.addresses != null) {
                result.addresses(this.addresses);
            }
            if (this.password != null) {
                connectionFactory.setPassword(this.password);
            }
            if (this.username != null) {
                connectionFactory.setUsername(this.username);
            }
            if (this.virtualHost != null) {
                connectionFactory.setVirtualHost(this.virtualHost);
            }
            if (this.useSsl != null && this.useSsl.booleanValue()) {
                connectionFactory.useSslProtocol();
            }
        }
        result.connectionFactory(connectionFactory);
        return result;
    }
}

