/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.List;
import zipkin.Span;
import zipkin.SpanDecoder;
import zipkin.internal.Util;
import zipkin.internal.V2JsonSpanDecoder;
import zipkin.internal.V2Proto3SpanDecoder;

public final class DetectingSpanDecoder
implements SpanDecoder {
    static final byte[] ENDPOINT_FIELD_SUFFIX = "Endpoint\"".getBytes(Util.UTF_8);
    static final byte[] TAGS_FIELD = new byte[]{34, 116, 97, 103, 115, 34};
    static final SpanDecoder JSON2_DECODER = new V2JsonSpanDecoder();
    static final SpanDecoder PROTO3_DECODER = new V2Proto3SpanDecoder();

    @Override
    public Span readSpan(byte[] span) {
        SpanDecoder decoder = DetectingSpanDecoder.detectFormat(span);
        if (span[0] == 12 || span[0] == 91) {
            throw new IllegalArgumentException("Expected json or thrift object, not list encoding");
        }
        return decoder.readSpan(span);
    }

    @Override
    public List<Span> readSpans(byte[] span) {
        SpanDecoder decoder = DetectingSpanDecoder.detectFormat(span);
        if (span[0] != 12 && !DetectingSpanDecoder.protobuf3(span) && span[0] != 91) {
            throw new IllegalArgumentException("Expected json, proto3 or thrift list encoding");
        }
        return decoder.readSpans(span);
    }

    public static SpanDecoder detectFormat(byte[] bytes) {
        if (bytes[0] <= 16) {
            if (DetectingSpanDecoder.protobuf3(bytes)) {
                return PROTO3_DECODER;
            }
            return THRIFT_DECODER;
        }
        if (bytes[0] != 91 && bytes[0] != 123) {
            throw new IllegalArgumentException("Could not detect the span format");
        }
        if (DetectingSpanDecoder.contains(bytes, ENDPOINT_FIELD_SUFFIX)) {
            return JSON2_DECODER;
        }
        if (DetectingSpanDecoder.contains(bytes, TAGS_FIELD)) {
            return JSON2_DECODER;
        }
        return SpanDecoder.JSON_DECODER;
    }

    static boolean contains(byte[] bytes, byte[] subsequence) {
        block0: for (int i = 0; i < bytes.length - subsequence.length + 1; ++i) {
            for (int j = 0; j < subsequence.length; ++j) {
                if (bytes[i + j] != subsequence[j]) continue block0;
            }
            return true;
        }
        return false;
    }

    static boolean protobuf3(byte[] bytes) {
        return bytes[0] == 10 && bytes[1] != 0;
    }
}

