/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Codec;
import zipkin.internal.Nullable;
import zipkin.internal.Util;

public final class Span
implements Comparable<Span>,
Serializable {
    private static final long serialVersionUID = 0L;
    public final long traceIdHigh;
    public final long traceId;
    public final String name;
    public final long id;
    @Nullable
    public final Long parentId;
    @Nullable
    public final Long timestamp;
    @Nullable
    public final Long duration;
    public final List<Annotation> annotations;
    public final List<BinaryAnnotation> binaryAnnotations;
    @Nullable
    public final Boolean debug;

    Span(Builder builder) {
        this.traceId = Util.checkNotNull(builder.traceId, "traceId");
        this.traceIdHigh = builder.traceIdHigh != null ? builder.traceIdHigh : 0L;
        this.name = Util.checkNotNull(builder.name, "name").isEmpty() ? "" : builder.name.toLowerCase(Locale.ROOT);
        this.id = Util.checkNotNull(builder.id, "id");
        this.parentId = builder.parentId;
        this.timestamp = builder.timestamp;
        this.duration = builder.duration;
        this.annotations = Util.sortedList(builder.annotations);
        this.binaryAnnotations = Util.sortedList(builder.binaryAnnotations);
        this.debug = builder.debug;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return new String(Codec.JSON.writeSpan(this), Util.UTF_8);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Span)) {
            return false;
        }
        Span that = (Span)o;
        return this.traceIdHigh == that.traceIdHigh && this.traceId == that.traceId && this.name.equals(that.name) && this.id == that.id && Util.equal(this.parentId, that.parentId) && Util.equal(this.timestamp, that.timestamp) && Util.equal(this.duration, that.duration) && this.annotations.equals(that.annotations) && this.binaryAnnotations.equals(that.binaryAnnotations) && Util.equal(this.debug, that.debug);
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= (int)((long)h ^ (this.traceIdHigh >>> 32 ^ this.traceIdHigh));
        h *= 1000003;
        h ^= (int)((long)h ^ (this.traceId >>> 32 ^ this.traceId));
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= (int)((long)h ^ (this.id >>> 32 ^ this.id));
        h *= 1000003;
        h ^= this.parentId == null ? 0 : this.parentId.hashCode();
        h *= 1000003;
        h ^= this.timestamp == null ? 0 : this.timestamp.hashCode();
        h *= 1000003;
        h ^= this.duration == null ? 0 : this.duration.hashCode();
        h *= 1000003;
        h ^= this.annotations.hashCode();
        h *= 1000003;
        h ^= this.binaryAnnotations.hashCode();
        h *= 1000003;
        return h ^= this.debug == null ? 0 : this.debug.hashCode();
    }

    @Override
    public int compareTo(Span that) {
        int byTimestamp;
        long y;
        if (this == that) {
            return 0;
        }
        long x = this.timestamp == null ? Long.MIN_VALUE : this.timestamp;
        long l = y = that.timestamp == null ? Long.MIN_VALUE : that.timestamp;
        int n = x < y ? -1 : (byTimestamp = x == y ? 0 : 1);
        if (byTimestamp != 0) {
            return byTimestamp;
        }
        return this.name.compareTo(that.name);
    }

    public String traceIdString() {
        if (this.traceIdHigh != 0L) {
            char[] result = new char[32];
            Util.writeHexLong(result, 0, this.traceIdHigh);
            Util.writeHexLong(result, 16, this.traceId);
            return new String(result);
        }
        char[] result = new char[16];
        Util.writeHexLong(result, 0, this.traceId);
        return new String(result);
    }

    public String idString() {
        int resultLength = 51;
        if (this.traceIdHigh != 0L) {
            resultLength += 16;
        }
        char[] result = new char[resultLength];
        int pos = 0;
        if (this.traceIdHigh != 0L) {
            Util.writeHexLong(result, pos, this.traceIdHigh);
            pos += 16;
        }
        Util.writeHexLong(result, pos, this.traceId);
        pos += 16;
        result[pos++] = 46;
        Util.writeHexLong(result, pos, this.id);
        pos += 16;
        result[pos++] = 60;
        result[pos++] = 58;
        Util.writeHexLong(result, pos, this.parentId != null ? this.parentId : this.id);
        return new String(result);
    }

    public Set<String> serviceNames() {
        HashSet<String> result = new HashSet<String>();
        for (Annotation annotation : this.annotations) {
            if (annotation.endpoint == null || annotation.endpoint.serviceName.isEmpty()) continue;
            result.add(annotation.endpoint.serviceName);
        }
        for (BinaryAnnotation binaryAnnotation : this.binaryAnnotations) {
            if (binaryAnnotation.endpoint == null || binaryAnnotation.endpoint.serviceName.isEmpty()) continue;
            result.add(binaryAnnotation.endpoint.serviceName);
        }
        return result;
    }

    final Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(Codec.THRIFT.writeSpan(this));
    }

    static boolean nameUnknown(Builder span) {
        return span.name == null || span.name.length() == 0 || span.name.equals("unknown");
    }

    static final class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final byte[] bytes;

        SerializedForm(byte[] bytes) {
            this.bytes = bytes;
        }

        Object readResolve() throws ObjectStreamException {
            try {
                return Codec.THRIFT.readSpan(this.bytes);
            }
            catch (IllegalArgumentException e) {
                throw new StreamCorruptedException(e.getMessage());
            }
        }
    }

    public static final class Builder {
        Long traceId;
        Long traceIdHigh;
        String name;
        Long id;
        Long parentId;
        Long timestamp;
        Long duration;
        ArrayList<Annotation> annotations;
        ArrayList<BinaryAnnotation> binaryAnnotations;
        Boolean debug;
        boolean isClientSpan;

        Builder() {
        }

        public Builder clear() {
            this.traceId = null;
            this.traceIdHigh = null;
            this.name = null;
            this.id = null;
            this.parentId = null;
            this.timestamp = null;
            this.duration = null;
            if (this.annotations != null) {
                this.annotations.clear();
            }
            if (this.binaryAnnotations != null) {
                this.binaryAnnotations.clear();
            }
            this.debug = null;
            this.isClientSpan = false;
            return this;
        }

        Builder(Span source) {
            this.traceId = source.traceId;
            this.traceIdHigh = source.traceIdHigh;
            this.name = source.name;
            this.id = source.id;
            this.parentId = source.parentId;
            this.timestamp = source.timestamp;
            this.duration = source.duration;
            if (!source.annotations.isEmpty()) {
                this.annotations(source.annotations);
            }
            if (!source.binaryAnnotations.isEmpty()) {
                this.binaryAnnotations(source.binaryAnnotations);
            }
            this.debug = source.debug;
        }

        public Builder merge(Span that) {
            if (this.traceId == null) {
                this.traceId = that.traceId;
            }
            if (this.traceIdHigh == null || this.traceIdHigh == 0L) {
                this.traceIdHigh = that.traceIdHigh;
            }
            if (this.id == null) {
                this.id = that.id;
            }
            if (this.parentId == null) {
                this.parentId = that.parentId;
            }
            boolean thisIsClientSpan = this.isClientSpan;
            boolean thatIsClientSpan = false;
            boolean thatIsServerSpan = false;
            if (!that.annotations.isEmpty()) {
                boolean thisHadNoAnnotations = this.annotations == null;
                for (Annotation annotation : that.annotations) {
                    if (annotation.value.equals("cs")) {
                        thatIsClientSpan = true;
                    }
                    if (annotation.value.equals("sr")) {
                        thatIsServerSpan = true;
                    }
                    if (!thisHadNoAnnotations && this.annotations.contains(annotation)) continue;
                    this.addAnnotation(annotation);
                }
            }
            if (Span.nameUnknown(this)) {
                this.name = that.name;
            } else if (thisIsClientSpan && thatIsServerSpan && !that.name.isEmpty()) {
                this.name = that.name;
            }
            if (!that.binaryAnnotations.isEmpty()) {
                boolean thisHadNoBinaryAnnotations = this.binaryAnnotations == null;
                for (BinaryAnnotation binaryAnnotation : that.binaryAnnotations) {
                    if (!thisHadNoBinaryAnnotations && this.binaryAnnotations.contains(binaryAnnotation)) continue;
                    this.addBinaryAnnotation(binaryAnnotation);
                }
            }
            if (this.timestamp == null || that.timestamp == null || this.timestamp.equals(that.timestamp)) {
                Long l = this.timestamp = this.timestamp != null ? this.timestamp : that.timestamp;
                if (this.duration == null) {
                    this.duration = that.duration;
                } else if (that.duration != null) {
                    this.duration = Math.max(this.duration, that.duration);
                }
            } else if (thatIsClientSpan) {
                this.timestamp = that.timestamp;
                this.duration = that.duration;
            } else if (!thisIsClientSpan) {
                this.timestamp = null;
                this.duration = null;
            }
            if (this.debug == null) {
                this.debug = that.debug;
            }
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder traceIdHigh(long traceIdHigh) {
            this.traceIdHigh = traceIdHigh;
            return this;
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder parentId(@Nullable Long parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder timestamp(@Nullable Long timestamp) {
            this.timestamp = timestamp != null && timestamp == 0L ? null : timestamp;
            return this;
        }

        public Builder duration(@Nullable Long duration) {
            this.duration = duration != null && duration == 0L ? null : duration;
            return this;
        }

        public Builder annotations(Collection<Annotation> annotations) {
            if (this.annotations != null) {
                this.annotations.clear();
            }
            for (Annotation a : annotations) {
                this.addAnnotation(a);
            }
            return this;
        }

        public Builder addAnnotation(Annotation annotation) {
            if (this.annotations == null) {
                this.annotations = new ArrayList(4);
            }
            if (annotation.value.equals("cs")) {
                this.isClientSpan = true;
            }
            this.annotations.add(annotation);
            return this;
        }

        public Builder binaryAnnotations(Collection<BinaryAnnotation> binaryAnnotations) {
            if (this.binaryAnnotations != null) {
                this.binaryAnnotations.clear();
            }
            for (BinaryAnnotation b : binaryAnnotations) {
                this.addBinaryAnnotation(b);
            }
            return this;
        }

        public Builder addBinaryAnnotation(BinaryAnnotation binaryAnnotation) {
            if (this.binaryAnnotations == null) {
                this.binaryAnnotations = new ArrayList(4);
            }
            this.binaryAnnotations.add(binaryAnnotation);
            return this;
        }

        public Builder debug(@Nullable Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Span build() {
            return new Span(this);
        }
    }
}

