/*
 * Decompiled with CFR 0.152.
 */
package zipkin;

import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import zipkin.internal.InetAddresses;
import zipkin.internal.JsonCodec;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin2.Endpoint;

public final class Endpoint
implements Serializable {
    private static final long serialVersionUID = 0L;
    public final String serviceName;
    public final int ipv4;
    @Nullable
    public final byte[] ipv6;
    @Nullable
    public final Short port;

    @Deprecated
    public static Endpoint create(String serviceName, int ipv4, int port) {
        return new Endpoint(serviceName, ipv4, null, port == 0 ? null : Short.valueOf((short)(port & 0xFFFF)));
    }

    public static Endpoint create(String serviceName, int ipv4) {
        return new Endpoint(serviceName, ipv4, null, null);
    }

    Endpoint(String serviceName, int ipv4, @Nullable byte[] ipv6, @Nullable Short port) {
        this.serviceName = Util.checkNotNull(serviceName, "serviceName").isEmpty() ? "" : serviceName.toLowerCase(Locale.ROOT);
        this.ipv4 = ipv4;
        this.ipv6 = ipv6;
        this.port = port;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public zipkin2.Endpoint toV2() {
        Endpoint.Builder result = zipkin2.Endpoint.newBuilder().serviceName(this.serviceName).port(this.port != null ? this.port & 0xFFFF : 0);
        if (this.ipv4 != 0) {
            result.parseIp("" + (this.ipv4 >> 24 & 0xFF) + '.' + (this.ipv4 >> 16 & 0xFF) + '.' + (this.ipv4 >> 8 & 0xFF) + '.' + (this.ipv4 & 0xFF));
        }
        if (this.ipv6 != null) {
            try {
                result.parseIp(Inet6Address.getByAddress(this.ipv6));
            }
            catch (UnknownHostException e) {
                throw new AssertionError((Object)e);
            }
        }
        return result.build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Endpoint) {
            Endpoint that = (Endpoint)o;
            return this.serviceName.equals(that.serviceName) && this.ipv4 == that.ipv4 && Arrays.equals(this.ipv6, that.ipv6) && Util.equal(this.port, that.port);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.serviceName.hashCode();
        h *= 1000003;
        h ^= this.ipv4;
        h *= 1000003;
        h ^= Arrays.hashCode(this.ipv6);
        h *= 1000003;
        return h ^= this.port == null ? 0 : this.port.hashCode();
    }

    public String toString() {
        return new String(JsonCodec.writeEndpoint(this), Util.UTF_8);
    }

    public static final class Builder {
        private String serviceName;
        private Integer ipv4;
        private byte[] ipv6;
        private Short port;

        Builder() {
        }

        Builder(Endpoint source) {
            this.serviceName = source.serviceName;
            this.ipv4 = source.ipv4;
            this.ipv6 = source.ipv6;
            this.port = source.port;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public boolean parseIp(@Nullable InetAddress addr) {
            if (addr == null) {
                return false;
            }
            byte[] addressBytes = addr.getAddress();
            if (addressBytes.length == 4) {
                this.ipv4(ByteBuffer.wrap(addressBytes).getInt());
            } else if (addressBytes.length == 16) {
                this.ipv6(addressBytes);
            } else {
                return false;
            }
            return true;
        }

        public boolean parseIp(@Nullable String ipString) {
            if (ipString == null) {
                return false;
            }
            byte[] addressBytes = InetAddresses.ipStringToBytes(ipString);
            if (addressBytes == null) {
                return false;
            }
            if (addressBytes.length == 4) {
                this.ipv4(ByteBuffer.wrap(addressBytes).getInt());
            } else if (addressBytes.length == 16) {
                this.ipv6(addressBytes);
            } else {
                return false;
            }
            return true;
        }

        public Builder ipv4(int ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public Builder ipv6(@Nullable byte[] ipv6) {
            if (ipv6 == null) {
                this.ipv6 = null;
                return this;
            }
            Util.checkArgument(ipv6.length == 16, "ipv6 addresses are 16 bytes: " + ipv6.length, new Object[0]);
            for (int i = 0; i < 10; ++i) {
                if (ipv6[i] == 0) continue;
                this.ipv6 = ipv6;
                return this;
            }
            ByteBuffer buf = ByteBuffer.wrap(ipv6, 10, 6);
            short flag = buf.getShort();
            if (flag == 0 || flag == -1) {
                int ipv4 = buf.getInt();
                if (flag == 0 && ipv4 == 1) {
                    this.ipv6 = ipv6;
                } else {
                    this.ipv4 = ipv4;
                }
            } else {
                this.ipv6 = ipv6;
            }
            return this;
        }

        public Builder port(int port) {
            Util.checkArgument(port <= 65535, "invalid port %s", port);
            this.port = port <= 0 ? null : Short.valueOf((short)(port & 0xFFFF));
            return this;
        }

        public Builder port(@Nullable Short port) {
            if (port == null || port != 0) {
                this.port = port;
            }
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this.serviceName, this.ipv4 == null ? 0 : this.ipv4, this.ipv6, this.port);
        }
    }
}

