/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

final class Base64 {
    private Base64() {
    }

    public static byte[] decode(String in) {
        char c;
        int limit;
        for (limit = in.length(); limit > 0 && ((c = in.charAt(limit - 1)) == '=' || c == '\n' || c == '\r' || c == ' ' || c == '\t'); --limit) {
        }
        byte[] out = new byte[(int)((long)limit * 6L / 8L)];
        int outCount = 0;
        int inCount = 0;
        int word = 0;
        for (int pos = 0; pos < limit; ++pos) {
            int bits;
            char c2 = in.charAt(pos);
            if (c2 >= 'A' && c2 <= 'Z') {
                bits = c2 - 65;
            } else if (c2 >= 'a' && c2 <= 'z') {
                bits = c2 - 71;
            } else if (c2 >= '0' && c2 <= '9') {
                bits = c2 + 4;
            } else if (c2 == '+' || c2 == '-') {
                bits = 62;
            } else if (c2 == '/' || c2 == '_') {
                bits = 63;
            } else {
                if (c2 == '\n' || c2 == '\r' || c2 == ' ' || c2 == '\t') continue;
                return null;
            }
            word = word << 6 | (byte)bits;
            if (++inCount % 4 != 0) continue;
            out[outCount++] = (byte)(word >> 16);
            out[outCount++] = (byte)(word >> 8);
            out[outCount++] = (byte)word;
        }
        int lastWordChars = inCount % 4;
        if (lastWordChars == 1) {
            return null;
        }
        if (lastWordChars == 2) {
            out[outCount++] = (byte)((word <<= 12) >> 16);
        } else if (lastWordChars == 3) {
            out[outCount++] = (byte)((word <<= 6) >> 16);
            out[outCount++] = (byte)(word >> 8);
        }
        if (outCount == out.length) {
            return out;
        }
        byte[] prefix = new byte[outCount];
        System.arraycopy(out, 0, prefix, 0, outCount);
        return prefix;
    }
}

