/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin2.internal.Node;

public final class CorrectForClockSkew {
    private static final Logger logger = Logger.getLogger(CorrectForClockSkew.class.getName());

    public static List<Span> apply(List<Span> spans) {
        return CorrectForClockSkew.apply(logger, spans);
    }

    static List<Span> apply(Logger logger, List<Span> spans) {
        if (spans.isEmpty()) {
            return spans;
        }
        String traceId = spans.get(0).traceIdString();
        Long rootSpanId = null;
        Node.TreeBuilder treeBuilder = new Node.TreeBuilder(logger, traceId);
        boolean dataError = false;
        int length = spans.size();
        for (int i = 0; i < length; ++i) {
            Span next = spans.get(i);
            if (next.parentId == null) {
                if (rootSpanId != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format("skipping redundant root span: traceId=%s, rootSpanId=%s, spanId=%s", traceId, Util.toLowerHex(rootSpanId), Util.toLowerHex(next.id)));
                    }
                    dataError = true;
                    continue;
                }
                rootSpanId = next.id;
            }
            if (treeBuilder.addNode(next.parentId != null ? Util.toLowerHex(next.parentId) : null, Util.toLowerHex(next.id), (Object)next)) continue;
            dataError = true;
        }
        if (rootSpanId == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("skipping clock skew adjustment due to missing root span: traceId=" + traceId);
            }
            return spans;
        }
        if (dataError) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("skipping clock skew adjustment due to data errors: traceId=" + traceId);
            }
            return spans;
        }
        Node tree = treeBuilder.build();
        CorrectForClockSkew.adjust((Node<Span>)tree, null);
        ArrayList<Span> result = new ArrayList<Span>(spans.size());
        Iterator i = tree.traverse();
        while (i.hasNext()) {
            result.add((Span)((Node)i.next()).value());
        }
        return result;
    }

    static void adjust(Node<Span> node, @Nullable ClockSkew skewFromParent) {
        ClockSkew skew;
        if (skewFromParent != null) {
            node.value((Object)CorrectForClockSkew.adjustTimestamps((Span)node.value(), skewFromParent));
        }
        if ((skew = CorrectForClockSkew.getClockSkew((Span)node.value())) != null) {
            node.value((Object)CorrectForClockSkew.adjustTimestamps((Span)node.value(), skew));
        } else if (skewFromParent != null && CorrectForClockSkew.isLocalSpan((Span)node.value())) {
            skew = skewFromParent;
        }
        for (Node child : node.children()) {
            CorrectForClockSkew.adjust((Node<Span>)child, skew);
        }
    }

    static boolean isLocalSpan(Span span) {
        int i;
        Endpoint endPoint = null;
        int length = span.annotations.size();
        for (i = 0; i < length; ++i) {
            Annotation annotation = span.annotations.get(i);
            if (endPoint == null) {
                endPoint = annotation.endpoint;
            }
            if (endPoint == null || endPoint.equals(annotation.endpoint)) continue;
            return false;
        }
        length = span.binaryAnnotations.size();
        for (i = 0; i < length; ++i) {
            BinaryAnnotation binaryAnnotation = span.binaryAnnotations.get(i);
            if (endPoint == null) {
                endPoint = binaryAnnotation.endpoint;
            }
            if (endPoint == null || endPoint.equals(binaryAnnotation.endpoint)) continue;
            return false;
        }
        return true;
    }

    static Span adjustTimestamps(Span span, ClockSkew skew) {
        int i;
        ArrayList<Annotation> annotations = null;
        Long annotationTimestamp = null;
        int length = span.annotations.size();
        for (i = 0; i < length; ++i) {
            Annotation a = span.annotations.get(i);
            if (a.endpoint == null || !CorrectForClockSkew.ipsMatch(skew.endpoint, a.endpoint)) continue;
            if (annotations == null) {
                annotations = new ArrayList<Annotation>(span.annotations);
            }
            if (span.timestamp != null && a.timestamp == span.timestamp) {
                annotationTimestamp = a.timestamp;
            }
            annotations.set(i, a.toBuilder().timestamp(a.timestamp - skew.skew).build());
        }
        if (annotations != null) {
            Span.Builder builder = span.toBuilder().annotations(annotations);
            if (annotationTimestamp != null) {
                builder.timestamp(annotationTimestamp - skew.skew);
            }
            return builder.build();
        }
        length = span.binaryAnnotations.size();
        for (i = 0; i < length; ++i) {
            BinaryAnnotation b = span.binaryAnnotations.get(i);
            if (b.endpoint == null || !b.key.equals("lc") || !CorrectForClockSkew.ipsMatch(skew.endpoint, b.endpoint)) continue;
            return span.toBuilder().timestamp(span.timestamp - skew.skew).build();
        }
        return span;
    }

    static boolean ipsMatch(Endpoint skew, Endpoint that) {
        if (skew.ipv6 != null && that.ipv6 != null && Arrays.equals(skew.ipv6, that.ipv6)) {
            return true;
        }
        return skew.ipv4 != 0 && that.ipv4 != 0 && skew.ipv4 == that.ipv4;
    }

    @Nullable
    static ClockSkew getClockSkew(Span span) {
        Endpoint client;
        Endpoint server;
        Map<String, Annotation> annotations = CorrectForClockSkew.asMap(span.annotations);
        Annotation clientSend = annotations.get("cs");
        Annotation clientRecv = annotations.get("cr");
        Annotation serverRecv = annotations.get("sr");
        Annotation serverSend = annotations.get("ss");
        if (clientSend == null || clientRecv == null || serverRecv == null || serverSend == null) {
            return null;
        }
        Endpoint endpoint = server = serverRecv.endpoint != null ? serverRecv.endpoint : serverSend.endpoint;
        if (server == null) {
            return null;
        }
        Endpoint endpoint2 = client = clientSend.endpoint != null ? clientSend.endpoint : clientRecv.endpoint;
        if (client == null) {
            return null;
        }
        if (CorrectForClockSkew.ipsMatch(server, client)) {
            return null;
        }
        long clientDuration = clientRecv.timestamp - clientSend.timestamp;
        long serverDuration = serverSend.timestamp - serverRecv.timestamp;
        if (clientDuration < serverDuration) {
            return null;
        }
        long latency = (clientDuration - serverDuration) / 2L;
        if (latency < 0L) {
            return null;
        }
        long skew = serverRecv.timestamp - latency - clientSend.timestamp;
        if (skew != 0L) {
            return new ClockSkew(server, skew);
        }
        return null;
    }

    static Map<String, Annotation> asMap(List<Annotation> annotations) {
        LinkedHashMap<String, Annotation> result = new LinkedHashMap<String, Annotation>(annotations.size());
        for (Annotation a : annotations) {
            result.put(a.value, a);
        }
        return result;
    }

    private CorrectForClockSkew() {
    }

    static class ClockSkew {
        final Endpoint endpoint;
        final long skew;

        public ClockSkew(Endpoint endpoint, long skew) {
            this.endpoint = endpoint;
            this.skew = skew;
        }
    }
}

