/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import zipkin2.Annotation;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.Buffer;
import zipkin2.internal.JsonEscaper;
import zipkin2.internal.Nullable;
import zipkin2.internal.V2SpanWriter;

public final class V1SpanWriter
implements Buffer.Writer<Span> {
    static final byte[] EMPTY_SERVICE = "{\"serviceName\":\"\"".getBytes(Charset.forName("UTF-8"));

    @Override
    public int sizeInBytes(Span value) {
        Integer endpointSize;
        Parsed parsed = V1SpanWriter.parse(value);
        if (value.localEndpoint() != null) {
            endpointSize = V2SpanWriter.endpointSizeInBytes(value.localEndpoint());
            if (value.localServiceName() == null) {
                endpointSize = endpointSize + 17;
            }
        } else {
            endpointSize = null;
        }
        int sizeInBytes = 13;
        sizeInBytes += value.traceId().length();
        if (value.parentId() != null) {
            sizeInBytes += 30;
        }
        sizeInBytes += 24;
        sizeInBytes += 10;
        if (value.name() != null) {
            sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(value.name());
        }
        if (!Boolean.TRUE.equals(value.shared()) || !"sr".equals(parsed.begin)) {
            if (value.timestamp() != null) {
                sizeInBytes += 13;
                sizeInBytes += Buffer.asciiSizeInBytes(value.timestamp());
            }
            if (value.duration() != null) {
                sizeInBytes += 12;
                sizeInBytes += Buffer.asciiSizeInBytes(value.duration());
            }
        }
        int annotationCount = value.annotations().size();
        if (parsed.startTs != null && parsed.begin != null) {
            ++annotationCount;
            sizeInBytes += V1SpanWriter.coreAnnotationSizeInBytes(parsed.startTs, endpointSize);
        }
        if (parsed.endTs != null && parsed.end != null) {
            ++annotationCount;
            sizeInBytes += V1SpanWriter.coreAnnotationSizeInBytes(parsed.endTs, endpointSize);
        }
        if (annotationCount > 0) {
            sizeInBytes += 17;
            if (annotationCount > 1) {
                sizeInBytes += annotationCount - 1;
            }
            int length = value.annotations().size();
            for (int i = 0; i < length; ++i) {
                sizeInBytes += V2SpanWriter.annotationSizeInBytes(value.annotations().get(i), endpointSize);
            }
        }
        int binaryAnnotationCount = value.tags().size();
        if (parsed.remoteEndpointType != null && value.remoteEndpoint() != null) {
            ++binaryAnnotationCount;
            sizeInBytes += 37;
            sizeInBytes += V2SpanWriter.endpointSizeInBytes(value.remoteEndpoint());
            if (value.localServiceName() == null) {
                sizeInBytes += 17;
            }
        }
        if (binaryAnnotationCount > 0) {
            sizeInBytes += 23;
            if (binaryAnnotationCount > 1) {
                sizeInBytes += binaryAnnotationCount - 1;
            }
            for (Map.Entry<String, String> tag : value.tags().entrySet()) {
                sizeInBytes += V1SpanWriter.binaryAnnotationSizeInBytes(tag.getKey(), tag.getValue(), endpointSize);
            }
        }
        if (Boolean.TRUE.equals(value.debug())) {
            sizeInBytes += 13;
        }
        return ++sizeInBytes;
    }

    @Override
    public void write(Span value, Buffer b) {
        boolean hasRemoteEndpoint;
        boolean endAnnotation;
        Parsed parsed = V1SpanWriter.parse(value);
        byte[] endpointBytes = V1SpanWriter.legacyEndpointBytes(value.localEndpoint());
        b.writeAscii("{\"traceId\":\"").writeAscii(value.traceId()).writeByte(34);
        if (value.parentId() != null) {
            b.writeAscii(",\"parentId\":\"").writeAscii(value.parentId()).writeByte(34);
        }
        b.writeAscii(",\"id\":\"").writeAscii(value.id()).writeByte(34);
        b.writeAscii(",\"name\":\"");
        if (value.name() != null) {
            b.writeUtf8(JsonEscaper.jsonEscape(value.name()));
        }
        b.writeByte(34);
        if (!Boolean.TRUE.equals(value.shared()) || !"sr".equals(parsed.begin)) {
            if (value.timestamp() != null) {
                b.writeAscii(",\"timestamp\":").writeAscii(value.timestamp());
            }
            if (value.duration() != null) {
                b.writeAscii(",\"duration\":").writeAscii(value.duration());
            }
        }
        int annotationCount = value.annotations().size();
        boolean beginAnnotation = parsed.startTs != null && parsed.begin != null;
        boolean bl = endAnnotation = parsed.endTs != null && parsed.end != null;
        if (annotationCount > 0) {
            int length = value.annotations().size();
            b.writeAscii(",\"annotations\":[");
            if (beginAnnotation) {
                V2SpanWriter.writeAnnotation(Annotation.create(parsed.startTs, parsed.begin), endpointBytes, b);
                if (length > 0) {
                    b.writeByte(44);
                }
            }
            int i = 0;
            while (i < length) {
                V2SpanWriter.writeAnnotation(value.annotations().get(i++), endpointBytes, b);
                if (i >= length) continue;
                b.writeByte(44);
            }
            if (endAnnotation) {
                if (length > 0) {
                    b.writeByte(44);
                }
                V2SpanWriter.writeAnnotation(Annotation.create(parsed.endTs, parsed.end), endpointBytes, b);
            }
            b.writeByte(93);
        }
        int binaryAnnotationCount = value.tags().size();
        boolean bl2 = hasRemoteEndpoint = parsed.remoteEndpointType != null && value.remoteEndpoint() != null;
        if (hasRemoteEndpoint) {
            ++binaryAnnotationCount;
        }
        if (binaryAnnotationCount > 0) {
            b.writeAscii(",\"binaryAnnotations\":[");
            Iterator<Map.Entry<String, String>> i = value.tags().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, String> entry = i.next();
                V1SpanWriter.writeBinaryAnnotation(entry.getKey(), entry.getValue(), endpointBytes, b);
                if (!i.hasNext()) continue;
                b.writeByte(44);
            }
            if (hasRemoteEndpoint) {
                if (!value.tags().isEmpty()) {
                    b.writeByte(44);
                }
                b.writeAscii("{\"key\":\"").writeAscii(parsed.remoteEndpointType);
                b.writeAscii("\",\"value\":true,\"endpoint\":");
                b.write(V1SpanWriter.legacyEndpointBytes(value.remoteEndpoint()));
                b.writeByte(125);
            }
            b.writeByte(93);
        }
        if (Boolean.TRUE.equals(value.debug())) {
            b.writeAscii(",\"debug\":true");
        }
        b.writeByte(125);
    }

    public String toString() {
        return "Span";
    }

    static byte[] legacyEndpointBytes(@Nullable Endpoint localEndpoint) {
        if (localEndpoint == null) {
            return null;
        }
        Buffer buffer = new Buffer(V2SpanWriter.endpointSizeInBytes(localEndpoint));
        V2SpanWriter.writeEndpoint(localEndpoint, buffer);
        byte[] endpointBytes = buffer.toByteArray();
        if (localEndpoint.serviceName() != null) {
            return endpointBytes;
        }
        byte[] newSpanBytes = new byte[EMPTY_SERVICE.length + endpointBytes.length];
        System.arraycopy(EMPTY_SERVICE, 0, newSpanBytes, 0, EMPTY_SERVICE.length);
        newSpanBytes[V1SpanWriter.EMPTY_SERVICE.length] = 44;
        System.arraycopy(endpointBytes, 1, newSpanBytes, 18, endpointBytes.length - 1);
        return newSpanBytes;
    }

    static int binaryAnnotationSizeInBytes(String key, String value, @Nullable Integer endpointSize) {
        int sizeInBytes = 21;
        sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(key);
        sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(value);
        if (endpointSize != null) {
            sizeInBytes += 12;
            sizeInBytes += endpointSize.intValue();
        }
        return sizeInBytes;
    }

    static void writeBinaryAnnotation(String key, String value, @Nullable byte[] endpoint, Buffer b) {
        b.writeAscii("{\"key\":\"").writeUtf8(JsonEscaper.jsonEscape(key));
        b.writeAscii("\",\"value\":\"").writeUtf8(JsonEscaper.jsonEscape(value)).writeByte(34);
        if (endpoint != null) {
            b.writeAscii(",\"endpoint\":").write(endpoint);
        }
        b.writeAscii("}");
    }

    static Parsed parse(Span in) {
        Parsed parsed = new Parsed();
        parsed.startTs = in.timestamp();
        Long l = parsed.endTs = in.timestamp() != null && in.duration() != null ? Long.valueOf(in.timestamp() + in.duration()) : null;
        if (in.kind() != null) {
            switch (in.kind()) {
                case CLIENT: {
                    parsed.remoteEndpointType = "sa";
                    parsed.begin = "cs";
                    parsed.end = "cr";
                    break;
                }
                case SERVER: {
                    parsed.remoteEndpointType = "ca";
                    parsed.begin = "sr";
                    parsed.end = "ss";
                    break;
                }
                case PRODUCER: {
                    parsed.remoteEndpointType = "ma";
                    parsed.begin = "ms";
                    parsed.end = "ws";
                    break;
                }
                case CONSUMER: {
                    parsed.remoteEndpointType = "ma";
                    if (parsed.endTs != null) {
                        parsed.begin = "wr";
                        parsed.end = "mr";
                        break;
                    }
                    parsed.begin = "mr";
                    break;
                }
                default: {
                    throw new AssertionError((Object)"update kind mapping");
                }
            }
        }
        return parsed;
    }

    static int coreAnnotationSizeInBytes(long timestamp, @Nullable Integer endpointSizeInBytes) {
        int sizeInBytes = 27;
        sizeInBytes += Buffer.asciiSizeInBytes(timestamp);
        if (endpointSizeInBytes != null) {
            sizeInBytes += 12;
            sizeInBytes += endpointSizeInBytes.intValue();
        }
        return sizeInBytes;
    }

    static class Parsed {
        Long startTs = null;
        Long endTs = null;
        String begin = null;
        String end = null;
        String remoteEndpointType = null;

        Parsed() {
        }
    }
}

