/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import zipkin2.internal.Buffer;
import zipkin2.internal.Nullable;
import zipkin2.internal.Platform;
import zipkin2.internal.gson.stream.JsonToken;

public final class JsonCodec {
    static final Charset UTF_8 = Charset.forName("UTF-8");

    public static <T> boolean read(JsonReaderAdapter<T> adapter, byte[] bytes, Collection<T> out) {
        if (bytes.length == 0) {
            return false;
        }
        try {
            out.add(adapter.fromJson(new JsonReader(bytes)));
            return true;
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading(adapter.toString(), e);
        }
    }

    @Nullable
    public static <T> T readOne(JsonReaderAdapter<T> adapter, byte[] bytes) {
        LinkedList out = new LinkedList();
        if (!JsonCodec.read(adapter, bytes, out)) {
            return null;
        }
        return (T)out.iterator().next();
    }

    public static <T> boolean readList(JsonReaderAdapter<T> adapter, byte[] bytes, Collection<T> out) {
        if (bytes.length == 0) {
            return false;
        }
        JsonReader reader = new JsonReader(bytes);
        try {
            reader.beginArray();
            if (!reader.hasNext()) {
                return false;
            }
            while (reader.hasNext()) {
                out.add(adapter.fromJson(reader));
            }
            reader.endArray();
            return true;
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading("List<" + adapter + ">", e);
        }
    }

    public static <T> List<T> readList(JsonReaderAdapter<T> adapter, byte[] bytes) {
        ArrayList out = new ArrayList();
        if (!JsonCodec.readList(adapter, bytes, out)) {
            return Collections.emptyList();
        }
        return out;
    }

    static <T> int sizeInBytes(Buffer.Writer<T> writer, List<T> value) {
        int length = value.size();
        int sizeInBytes = 2;
        if (length > 1) {
            sizeInBytes += length - 1;
        }
        for (int i = 0; i < length; ++i) {
            sizeInBytes += writer.sizeInBytes(value.get(i));
        }
        return sizeInBytes;
    }

    public static <T> byte[] write(Buffer.Writer<T> writer, T value) {
        Buffer b = new Buffer(writer.sizeInBytes(value));
        try {
            writer.write(value, b);
        }
        catch (RuntimeException e) {
            byte[] bytesWritten;
            byte[] bytes = b.toByteArray();
            int lengthWritten = bytes.length;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                lengthWritten = i;
                break;
            }
            if (lengthWritten == bytes.length) {
                bytesWritten = bytes;
            } else {
                bytesWritten = new byte[lengthWritten];
                System.arraycopy(bytes, 0, bytesWritten, 0, lengthWritten);
            }
            String written = new String(bytesWritten, UTF_8);
            String message = String.format("Bug found using %s to write %s as json. Wrote %s/%s bytes: %s", writer.getClass().getSimpleName().replace("AutoValue_", ""), value.getClass().getSimpleName(), lengthWritten, bytes.length, written);
            throw Platform.get().assertionError(message, e);
        }
        return b.toByteArray();
    }

    public static <T> byte[] writeList(Buffer.Writer<T> writer, List<T> value) {
        if (value.isEmpty()) {
            return new byte[]{91, 93};
        }
        Buffer result = new Buffer(JsonCodec.sizeInBytes(writer, value));
        JsonCodec.writeList(writer, value, result);
        return result.toByteArray();
    }

    public static <T> int writeList(Buffer.Writer<T> writer, List<T> value, byte[] out, int pos) {
        if (value.isEmpty()) {
            out[pos++] = 91;
            out[pos++] = 93;
            return 2;
        }
        int length = JsonCodec.sizeInBytes(writer, value);
        Buffer result = new Buffer(out, pos);
        JsonCodec.writeList(writer, value, result);
        return length;
    }

    public static <T> void writeList(Buffer.Writer<T> writer, List<T> value, Buffer b) {
        b.writeByte(91);
        int i = 0;
        int length = value.size();
        while (i < length) {
            writer.write(value.get(i++), b);
            if (i >= length) continue;
            b.writeByte(44);
        }
        b.writeByte(93);
    }

    static IllegalArgumentException exceptionReading(String type, Exception e) {
        String cause;
        String string = cause = e.getMessage() == null ? "Error" : e.getMessage();
        if (cause.indexOf("malformed") != -1) {
            cause = "Malformed";
        }
        String message = String.format("%s reading %s from json", cause, type);
        throw new IllegalArgumentException(message, e);
    }

    public static interface JsonReaderAdapter<T> {
        public T fromJson(JsonReader var1) throws IOException;
    }

    public static final class JsonReader {
        final zipkin2.internal.gson.stream.JsonReader delegate;

        JsonReader(byte[] bytes) {
            this.delegate = new zipkin2.internal.gson.stream.JsonReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), UTF_8));
        }

        public void beginArray() throws IOException {
            this.delegate.beginArray();
        }

        public boolean hasNext() throws IOException {
            return this.delegate.hasNext();
        }

        public void endArray() throws IOException {
            this.delegate.endArray();
        }

        public void beginObject() throws IOException {
            this.delegate.beginObject();
        }

        public void endObject() throws IOException {
            this.delegate.endObject();
        }

        public String nextName() throws IOException {
            return this.delegate.nextName();
        }

        public String nextString() throws IOException {
            return this.delegate.nextString();
        }

        public void skipValue() throws IOException {
            this.delegate.skipValue();
        }

        public long nextLong() throws IOException {
            return this.delegate.nextLong();
        }

        public String getPath() throws IOException {
            return this.delegate.getPath();
        }

        public boolean nextBoolean() throws IOException {
            return this.delegate.nextBoolean();
        }

        public int nextInt() throws IOException {
            return this.delegate.nextInt();
        }

        public boolean peekNull() throws IOException {
            return this.delegate.peek() == JsonToken.NULL;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

