/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import zipkin.internal.Util;

public final class Buffer {
    private final byte[] buf;
    private int pos;

    Buffer(int size) {
        this.buf = new byte[size];
    }

    public Buffer writeByte(int v) {
        this.buf[this.pos++] = (byte)v;
        return this;
    }

    Buffer write(byte[] v) {
        System.arraycopy(v, 0, this.buf, this.pos, v.length);
        this.pos += v.length;
        return this;
    }

    Buffer writeShort(int v) {
        this.writeByte(v >>> 8 & 0xFF);
        this.writeByte(v & 0xFF);
        return this;
    }

    Buffer writeInt(int v) {
        this.buf[this.pos++] = (byte)(v >>> 24 & 0xFF);
        this.buf[this.pos++] = (byte)(v >>> 16 & 0xFF);
        this.buf[this.pos++] = (byte)(v >>> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(v & 0xFF);
        return this;
    }

    Buffer writeLong(long v) {
        this.buf[this.pos++] = (byte)(v >>> 56 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 48 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 40 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 32 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 24 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 16 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 8 & 0xFFL);
        this.buf[this.pos++] = (byte)(v & 0xFFL);
        return this;
    }

    static int utf8SizeInBytes(String string) {
        int sizeInBytes = 0;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char low;
            char ch = string.charAt(i);
            if (ch < '\u0080') {
                ++sizeInBytes;
                continue;
            }
            if (ch < '\u0800') {
                sizeInBytes += 2;
                continue;
            }
            if (ch < '\ud800' || ch > '\udfff') {
                sizeInBytes += 3;
                continue;
            }
            char c = low = i + 1 < len ? string.charAt(i + 1) : (char)'\u0000';
            if (ch > '\udbff' || low < '\udc00' || low > '\udfff') {
                ++sizeInBytes;
                continue;
            }
            sizeInBytes += 4;
            ++i;
        }
        return sizeInBytes;
    }

    Buffer writeLengthPrefixed(String v) {
        boolean ascii = Buffer.isAscii(v);
        if (ascii) {
            this.writeInt(v.length());
            return this.writeAscii(v);
        }
        byte[] temp = v.getBytes(Util.UTF_8);
        this.writeInt(temp.length);
        this.write(temp);
        return this;
    }

    Buffer writeAscii(String v) {
        int length = v.length();
        for (int i = 0; i < length; ++i) {
            this.buf[this.pos++] = (byte)v.charAt(i);
        }
        return this;
    }

    static boolean isAscii(String v) {
        int length = v.length();
        for (int i = 0; i < length; ++i) {
            if (v.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    byte[] toByteArray() {
        return this.buf;
    }

    public static interface Writer<T> {
        public int sizeInBytes(T var1);

        public void write(T var1, Buffer var2);
    }
}

