/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2.storage;

import java.util.Map;
import javax.annotation.Nullable;
import zipkin.internal.v2.storage.QueryRequest;

final class AutoValue_QueryRequest
extends QueryRequest {
    private final String serviceName;
    private final String spanName;
    private final Map<String, String> annotationQuery;
    private final Long minDuration;
    private final Long maxDuration;
    private final long endTs;
    private final long lookback;
    private final int limit;

    private AutoValue_QueryRequest(@Nullable String serviceName, @Nullable String spanName, Map<String, String> annotationQuery, @Nullable Long minDuration, @Nullable Long maxDuration, long endTs, long lookback, int limit) {
        this.serviceName = serviceName;
        this.spanName = spanName;
        this.annotationQuery = annotationQuery;
        this.minDuration = minDuration;
        this.maxDuration = maxDuration;
        this.endTs = endTs;
        this.lookback = lookback;
        this.limit = limit;
    }

    @Override
    @Nullable
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    @Nullable
    public String spanName() {
        return this.spanName;
    }

    @Override
    public Map<String, String> annotationQuery() {
        return this.annotationQuery;
    }

    @Override
    @Nullable
    public Long minDuration() {
        return this.minDuration;
    }

    @Override
    @Nullable
    public Long maxDuration() {
        return this.maxDuration;
    }

    @Override
    public long endTs() {
        return this.endTs;
    }

    @Override
    public long lookback() {
        return this.lookback;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public String toString() {
        return "QueryRequest{serviceName=" + this.serviceName + ", spanName=" + this.spanName + ", annotationQuery=" + this.annotationQuery + ", minDuration=" + this.minDuration + ", maxDuration=" + this.maxDuration + ", endTs=" + this.endTs + ", lookback=" + this.lookback + ", limit=" + this.limit + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryRequest) {
            QueryRequest that = (QueryRequest)o;
            return (this.serviceName == null ? that.serviceName() == null : this.serviceName.equals(that.serviceName())) && (this.spanName == null ? that.spanName() == null : this.spanName.equals(that.spanName())) && this.annotationQuery.equals(that.annotationQuery()) && (this.minDuration == null ? that.minDuration() == null : this.minDuration.equals(that.minDuration())) && (this.maxDuration == null ? that.maxDuration() == null : this.maxDuration.equals(that.maxDuration())) && this.endTs == that.endTs() && this.lookback == that.lookback() && this.limit == that.limit();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.serviceName == null ? 0 : this.serviceName.hashCode();
        h *= 1000003;
        h ^= this.spanName == null ? 0 : this.spanName.hashCode();
        h *= 1000003;
        h ^= this.annotationQuery.hashCode();
        h *= 1000003;
        h ^= this.minDuration == null ? 0 : this.minDuration.hashCode();
        h *= 1000003;
        h ^= this.maxDuration == null ? 0 : this.maxDuration.hashCode();
        h *= 1000003;
        h ^= (int)(this.endTs >>> 32 ^ this.endTs);
        h *= 1000003;
        h ^= (int)(this.lookback >>> 32 ^ this.lookback);
        h *= 1000003;
        return h ^= this.limit;
    }

    @Override
    public QueryRequest.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends QueryRequest.Builder {
        private String serviceName;
        private String spanName;
        private Map<String, String> annotationQuery;
        private Long minDuration;
        private Long maxDuration;
        private Long endTs;
        private Long lookback;
        private Integer limit;

        Builder() {
        }

        private Builder(QueryRequest source) {
            this.serviceName = source.serviceName();
            this.spanName = source.spanName();
            this.annotationQuery = source.annotationQuery();
            this.minDuration = source.minDuration();
            this.maxDuration = source.maxDuration();
            this.endTs = source.endTs();
            this.lookback = source.lookback();
            this.limit = source.limit();
        }

        @Override
        public QueryRequest.Builder serviceName(@Nullable String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        @Nullable
        String serviceName() {
            return this.serviceName;
        }

        @Override
        public QueryRequest.Builder spanName(@Nullable String spanName) {
            this.spanName = spanName;
            return this;
        }

        @Override
        @Nullable
        String spanName() {
            return this.spanName;
        }

        @Override
        public QueryRequest.Builder annotationQuery(Map<String, String> annotationQuery) {
            if (annotationQuery == null) {
                throw new NullPointerException("Null annotationQuery");
            }
            this.annotationQuery = annotationQuery;
            return this;
        }

        @Override
        Map<String, String> annotationQuery() {
            if (this.annotationQuery == null) {
                throw new IllegalStateException("Property \"annotationQuery\" has not been set");
            }
            return this.annotationQuery;
        }

        @Override
        public QueryRequest.Builder minDuration(@Nullable Long minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        @Override
        @Nullable
        Long minDuration() {
            return this.minDuration;
        }

        @Override
        public QueryRequest.Builder maxDuration(@Nullable Long maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        @Override
        @Nullable
        Long maxDuration() {
            return this.maxDuration;
        }

        @Override
        public QueryRequest.Builder endTs(long endTs) {
            this.endTs = endTs;
            return this;
        }

        @Override
        long endTs() {
            if (this.endTs == null) {
                throw new IllegalStateException("Property \"endTs\" has not been set");
            }
            return this.endTs;
        }

        @Override
        public QueryRequest.Builder lookback(long lookback) {
            this.lookback = lookback;
            return this;
        }

        @Override
        public QueryRequest.Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        int limit() {
            if (this.limit == null) {
                throw new IllegalStateException("Property \"limit\" has not been set");
            }
            return this.limit;
        }

        @Override
        QueryRequest autoBuild() {
            String missing = "";
            if (this.annotationQuery == null) {
                missing = missing + " annotationQuery";
            }
            if (this.endTs == null) {
                missing = missing + " endTs";
            }
            if (this.lookback == null) {
                missing = missing + " lookback";
            }
            if (this.limit == null) {
                missing = missing + " limit";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_QueryRequest(this.serviceName, this.spanName, this.annotationQuery, this.minDuration, this.maxDuration, this.endTs, this.lookback, this.limit);
        }
    }
}

