/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2.codec;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import zipkin.internal.Buffer;
import zipkin.internal.JsonCodec;
import zipkin.internal.gson.stream.JsonReader;
import zipkin.internal.gson.stream.JsonToken;
import zipkin.internal.gson.stream.MalformedJsonException;
import zipkin.internal.v2.Annotation;
import zipkin.internal.v2.Endpoint;
import zipkin.internal.v2.Span;
import zipkin.internal.v2.codec.Span2JsonAdapters$$Lambda$1;

final class Span2JsonAdapters {
    static final JsonCodec.JsonReaderAdapter<Endpoint> ENDPOINT_READER = Span2JsonAdapters$$Lambda$1.lambdaFactory$();
    static final Buffer.Writer<Endpoint> ENDPOINT_WRITER = new Buffer.Writer<Endpoint>(){

        @Override
        public int sizeInBytes(Endpoint value) {
            int sizeInBytes = 1;
            if (value.serviceName() != null) {
                sizeInBytes += 16;
                sizeInBytes += Buffer.jsonEscapedSizeInBytes(value.serviceName());
            }
            if (value.ipv4() != null) {
                if (sizeInBytes != 1) {
                    ++sizeInBytes;
                }
                sizeInBytes += 9;
                sizeInBytes += value.ipv4().length();
            }
            if (value.ipv6() != null) {
                if (sizeInBytes != 1) {
                    ++sizeInBytes;
                }
                sizeInBytes += 9;
                sizeInBytes += value.ipv6().length();
            }
            if (value.port() != null) {
                if (sizeInBytes != 1) {
                    ++sizeInBytes;
                }
                sizeInBytes += 7;
                sizeInBytes += Buffer.asciiSizeInBytes(value.port().intValue());
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(Endpoint value, Buffer b) {
            b.writeByte(123);
            boolean wroteField = false;
            if (value.serviceName() != null) {
                b.writeAscii("\"serviceName\":\"");
                b.writeJsonEscaped(value.serviceName()).writeByte(34);
                wroteField = true;
            }
            if (value.ipv4() != null) {
                if (wroteField) {
                    b.writeByte(44);
                }
                b.writeAscii("\"ipv4\":\"");
                b.writeAscii(value.ipv4()).writeByte(34);
                wroteField = true;
            }
            if (value.ipv6() != null) {
                if (wroteField) {
                    b.writeByte(44);
                }
                b.writeAscii("\"ipv6\":\"");
                b.writeAscii(value.ipv6()).writeByte(34);
                wroteField = true;
            }
            if (value.port() != null) {
                if (wroteField) {
                    b.writeByte(44);
                }
                b.writeAscii("\"port\":").writeAscii(value.port().intValue());
            }
            b.writeByte(125);
        }
    };
    static final Buffer.Writer<Span> SPAN_WRITER = new Buffer.Writer<Span>(){

        @Override
        public int sizeInBytes(Span value) {
            int sizeInBytes = 13;
            sizeInBytes += value.traceId().length();
            if (value.parentId() != null) {
                sizeInBytes += 30;
            }
            sizeInBytes += 24;
            if (value.kind() != null) {
                sizeInBytes += 10;
                sizeInBytes += value.kind().name().length();
            }
            if (value.name() != null) {
                sizeInBytes += 10;
                sizeInBytes += Buffer.jsonEscapedSizeInBytes(value.name());
            }
            if (value.timestamp() != null) {
                sizeInBytes += 13;
                sizeInBytes += Buffer.asciiSizeInBytes(value.timestamp());
            }
            if (value.duration() != null) {
                sizeInBytes += 12;
                sizeInBytes += Buffer.asciiSizeInBytes(value.duration());
            }
            if (value.localEndpoint() != null) {
                sizeInBytes += 17;
                sizeInBytes += ENDPOINT_WRITER.sizeInBytes(value.localEndpoint());
            }
            if (value.remoteEndpoint() != null) {
                sizeInBytes += 18;
                sizeInBytes += ENDPOINT_WRITER.sizeInBytes(value.remoteEndpoint());
            }
            if (!value.annotations().isEmpty()) {
                sizeInBytes += 17;
                int length = value.annotations().size();
                if (length > 1) {
                    sizeInBytes += length - 1;
                }
                for (int i = 0; i < length; ++i) {
                    sizeInBytes += ANNOTATION_WRITER.sizeInBytes(value.annotations().get(i));
                }
            }
            if (!value.tags().isEmpty()) {
                sizeInBytes += 10;
                int tagCount = value.tags().size();
                if (tagCount > 1) {
                    sizeInBytes += tagCount - 1;
                }
                for (Map.Entry<String, String> entry : value.tags().entrySet()) {
                    sizeInBytes += 5;
                    sizeInBytes += Buffer.jsonEscapedSizeInBytes(entry.getKey());
                    sizeInBytes += Buffer.jsonEscapedSizeInBytes(entry.getValue());
                }
            }
            if (Boolean.TRUE.equals(value.debug())) {
                sizeInBytes += 13;
            }
            if (Boolean.TRUE.equals(value.shared())) {
                sizeInBytes += 14;
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(Span value, Buffer b) {
            b.writeAscii("{\"traceId\":\"").writeAscii(value.traceId()).writeByte(34);
            if (value.parentId() != null) {
                b.writeAscii(",\"parentId\":\"").writeAscii(value.parentId()).writeByte(34);
            }
            b.writeAscii(",\"id\":\"").writeAscii(value.id()).writeByte(34);
            if (value.kind() != null) {
                b.writeAscii(",\"kind\":\"").writeJsonEscaped(value.kind().toString()).writeByte(34);
            }
            if (value.name() != null) {
                b.writeAscii(",\"name\":\"").writeJsonEscaped(value.name()).writeByte(34);
            }
            if (value.timestamp() != null) {
                b.writeAscii(",\"timestamp\":").writeAscii(value.timestamp());
            }
            if (value.duration() != null) {
                b.writeAscii(",\"duration\":").writeAscii(value.duration());
            }
            if (value.localEndpoint() != null) {
                b.writeAscii(",\"localEndpoint\":");
                ENDPOINT_WRITER.write(value.localEndpoint(), b);
            }
            if (value.remoteEndpoint() != null) {
                b.writeAscii(",\"remoteEndpoint\":");
                ENDPOINT_WRITER.write(value.remoteEndpoint(), b);
            }
            if (!value.annotations().isEmpty()) {
                b.writeAscii(",\"annotations\":");
                JsonCodec.writeList(ANNOTATION_WRITER, value.annotations(), b);
            }
            if (!value.tags().isEmpty()) {
                b.writeAscii(",\"tags\":{");
                Iterator<Map.Entry<String, String>> i = value.tags().entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, String> entry = i.next();
                    b.writeByte(34).writeJsonEscaped(entry.getKey()).writeAscii("\":\"");
                    b.writeJsonEscaped(entry.getValue()).writeByte(34);
                    if (!i.hasNext()) continue;
                    b.writeByte(44);
                }
                b.writeByte(125);
            }
            if (Boolean.TRUE.equals(value.debug())) {
                b.writeAscii(",\"debug\":true");
            }
            if (Boolean.TRUE.equals(value.shared())) {
                b.writeAscii(",\"shared\":true");
            }
            b.writeByte(125);
        }

        public String toString() {
            return "Span";
        }
    };
    static final Buffer.Writer<Annotation> ANNOTATION_WRITER = new Buffer.Writer<Annotation>(){

        @Override
        public int sizeInBytes(Annotation value) {
            int sizeInBytes = 25;
            sizeInBytes += Buffer.asciiSizeInBytes(value.timestamp());
            return sizeInBytes += Buffer.jsonEscapedSizeInBytes(value.value());
        }

        @Override
        public void write(Annotation value, Buffer b) {
            b.writeAscii("{\"timestamp\":").writeAscii(value.timestamp());
            b.writeAscii(",\"value\":\"").writeJsonEscaped(value.value()).writeAscii("\"}");
        }
    };

    Span2JsonAdapters() {
    }

    static /* synthetic */ Endpoint lambda$static$0(JsonReader reader) throws IOException {
        Endpoint.Builder result = Endpoint.newBuilder();
        reader.beginObject();
        boolean readField = false;
        while (reader.hasNext()) {
            String nextName = reader.nextName();
            if (reader.peek() == JsonToken.NULL) {
                reader.skipValue();
                continue;
            }
            if (nextName.equals("serviceName")) {
                result.serviceName(reader.nextString());
                readField = true;
                continue;
            }
            if (nextName.equals("ipv4") || nextName.equals("ipv6")) {
                result.parseIp(reader.nextString());
                readField = true;
                continue;
            }
            if (nextName.equals("port")) {
                result.port(reader.nextInt());
                readField = true;
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (!readField) {
            throw new MalformedJsonException("Empty endpoint at " + reader.getPath());
        }
        return result.build();
    }

    static final class Span2ListReader
    implements JsonCodec.JsonReaderAdapter<List<Span>> {
        Span2Reader spanReader;

        Span2ListReader() {
        }

        @Override
        public List<Span> fromJson(JsonReader reader) throws IOException {
            reader.beginArray();
            if (!reader.hasNext()) {
                reader.endArray();
                return Collections.emptyList();
            }
            LinkedList<Span> result = new LinkedList<Span>();
            if (this.spanReader == null) {
                this.spanReader = new Span2Reader();
            }
            while (reader.hasNext()) {
                result.add(this.spanReader.fromJson(reader));
            }
            reader.endArray();
            return result;
        }

        public String toString() {
            return "List<Span>";
        }
    }

    static final class Span2Reader
    implements JsonCodec.JsonReaderAdapter<Span> {
        Span.Builder builder;

        Span2Reader() {
        }

        @Override
        public Span fromJson(JsonReader reader) throws IOException {
            if (this.builder == null) {
                this.builder = Span.newBuilder();
            } else {
                this.builder.clear();
            }
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("traceId")) {
                    this.builder.traceId(reader.nextString());
                    continue;
                }
                if (nextName.equals("id")) {
                    this.builder.id(reader.nextString());
                    continue;
                }
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    continue;
                }
                if (nextName.equals("parentId")) {
                    this.builder.parentId(reader.nextString());
                    continue;
                }
                if (nextName.equals("kind")) {
                    this.builder.kind(Span.Kind.valueOf(reader.nextString()));
                    continue;
                }
                if (nextName.equals("name")) {
                    this.builder.name(reader.nextString());
                    continue;
                }
                if (nextName.equals("timestamp")) {
                    this.builder.timestamp(reader.nextLong());
                    continue;
                }
                if (nextName.equals("duration")) {
                    this.builder.duration(reader.nextLong());
                    continue;
                }
                if (nextName.equals("localEndpoint")) {
                    this.builder.localEndpoint(ENDPOINT_READER.fromJson(reader));
                    continue;
                }
                if (nextName.equals("remoteEndpoint")) {
                    this.builder.remoteEndpoint(ENDPOINT_READER.fromJson(reader));
                    continue;
                }
                if (nextName.equals("annotations")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        reader.beginObject();
                        Long timestamp = null;
                        String value = null;
                        while (reader.hasNext()) {
                            nextName = reader.nextName();
                            if (nextName.equals("timestamp")) {
                                timestamp = reader.nextLong();
                                continue;
                            }
                            if (nextName.equals("value")) {
                                value = reader.nextString();
                                continue;
                            }
                            reader.skipValue();
                        }
                        if (timestamp == null || value == null) {
                            throw new MalformedJsonException("Incomplete annotation at " + reader.getPath());
                        }
                        reader.endObject();
                        this.builder.addAnnotation(timestamp, value);
                    }
                    reader.endArray();
                    continue;
                }
                if (nextName.equals("tags")) {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        String key = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            throw new MalformedJsonException("No value at " + reader.getPath());
                        }
                        this.builder.putTag(key, reader.nextString());
                    }
                    reader.endObject();
                    continue;
                }
                if (nextName.equals("debug")) {
                    if (!reader.nextBoolean()) continue;
                    this.builder.debug(true);
                    continue;
                }
                if (nextName.equals("shared")) {
                    if (!reader.nextBoolean()) continue;
                    this.builder.shared(true);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return this.builder.build();
        }

        public String toString() {
            return "Span";
        }
    }
}

