/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import zipkin.DependencyLink;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.GroupByTraceId;
import zipkin.internal.MergeById;
import zipkin.internal.Util;
import zipkin.internal.V2CallbackAdapter;
import zipkin.internal.V2SpanConverter;
import zipkin.internal.V2SpanStoreAdapter$$Lambda$1;
import zipkin.internal.V2SpanStoreAdapter$$Lambda$2;
import zipkin.internal.V2SpanStoreAdapter$$Lambda$3;
import zipkin.internal.v2.Call;
import zipkin.internal.v2.Span;
import zipkin.internal.v2.internal.Platform;
import zipkin.internal.v2.storage.QueryRequest;
import zipkin.internal.v2.storage.SpanStore;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;

final class V2SpanStoreAdapter
implements zipkin.storage.SpanStore,
AsyncSpanStore {
    final SpanStore delegate;
    static final Call.Mapper<List<List<Span>>, List<List<zipkin.Span>>> getTracesMapper = V2SpanStoreAdapter$$Lambda$1.lambdaFactory$();
    static final Call.Mapper<List<Span>, List<zipkin.Span>> getTraceMapper = V2SpanStoreAdapter$$Lambda$2.lambdaFactory$();
    static final Call.Mapper<List<Span>, List<zipkin.Span>> getRawTraceMapper = V2SpanStoreAdapter$$Lambda$3.lambdaFactory$();

    V2SpanStoreAdapter(SpanStore delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<List<zipkin.Span>> getTraces(zipkin.storage.QueryRequest request) {
        try {
            return this.getTracesCall(request).execute();
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getTraces(zipkin.storage.QueryRequest request, Callback<List<List<zipkin.Span>>> callback) {
        this.getTracesCall(request).enqueue(new V2CallbackAdapter<List<List<zipkin.Span>>>(callback));
    }

    Call<List<List<zipkin.Span>>> getTracesCall(zipkin.storage.QueryRequest v1Request) {
        return this.delegate.getTraces(V2SpanStoreAdapter.convert(v1Request)).map(getTracesMapper);
    }

    @Override
    @Nullable
    public List<zipkin.Span> getTrace(long traceIdHigh, long traceIdLow) {
        try {
            return this.getTraceCall(traceIdHigh, traceIdLow).execute();
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getTrace(long traceIdHigh, long traceIdLow, Callback<List<zipkin.Span>> callback) {
        this.getTraceCall(traceIdHigh, traceIdLow).enqueue(new V2CallbackAdapter<List<zipkin.Span>>(callback));
    }

    Call<List<zipkin.Span>> getTraceCall(long traceIdHigh, long traceIdLow) {
        return this.delegate.getTrace(Util.toLowerHex(traceIdHigh, traceIdLow)).map(getTraceMapper);
    }

    @Override
    @Nullable
    public List<zipkin.Span> getRawTrace(long traceIdHigh, long traceIdLow) {
        try {
            return this.getRawTraceCall(traceIdHigh, traceIdLow).execute();
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getRawTrace(long traceIdHigh, long traceIdLow, Callback<List<zipkin.Span>> callback) {
        this.getRawTraceCall(traceIdHigh, traceIdLow).enqueue(new V2CallbackAdapter<List<zipkin.Span>>(callback));
    }

    Call<List<zipkin.Span>> getRawTraceCall(long traceIdHigh, long traceIdLow) {
        return this.delegate.getTrace(Util.toLowerHex(traceIdHigh, traceIdLow)).map(getRawTraceMapper);
    }

    @Override
    public List<String> getServiceNames() {
        try {
            return Util.sortedList((Collection)this.delegate.getServiceNames().execute());
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getServiceNames(Callback<List<String>> callback) {
        this.delegate.getServiceNames().enqueue(new V2CallbackAdapter<List<String>>(callback));
    }

    @Override
    public List<String> getSpanNames(String serviceName) {
        try {
            return Util.sortedList((Collection)this.delegate.getSpanNames(serviceName).execute());
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getSpanNames(String serviceName, Callback<List<String>> callback) {
        this.delegate.getSpanNames(serviceName).enqueue(new V2CallbackAdapter<List<String>>(callback));
    }

    @Override
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        try {
            return this.getDependenciesCall(endTs, lookback).execute();
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getDependencies(long endTs, @Nullable Long lookback, Callback<List<DependencyLink>> callback) {
        this.getDependenciesCall(endTs, lookback).enqueue(new V2CallbackAdapter<List<DependencyLink>>(callback));
    }

    Call<List<DependencyLink>> getDependenciesCall(long endTs, @Nullable Long lookback) {
        return this.delegate.getDependencies(endTs, lookback != null ? lookback : endTs);
    }

    @Override
    @Nullable
    public List<zipkin.Span> getTrace(long traceId) {
        return this.getTrace(0L, traceId);
    }

    @Override
    public void getTrace(long id, Callback<List<zipkin.Span>> callback) {
        this.getTrace(0L, id, callback);
    }

    @Override
    @Nullable
    public List<zipkin.Span> getRawTrace(long traceId) {
        return this.getRawTrace(0L, traceId);
    }

    @Override
    public void getRawTrace(long traceId, Callback<List<zipkin.Span>> callback) {
        this.getRawTrace(0L, traceId, callback);
    }

    static QueryRequest convert(zipkin.storage.QueryRequest v1Request) {
        return QueryRequest.newBuilder().serviceName(v1Request.serviceName).spanName(v1Request.spanName).parseAnnotationQuery(v1Request.toAnnotationQuery()).minDuration(v1Request.minDuration).maxDuration(v1Request.maxDuration).endTs(v1Request.endTs).lookback(v1Request.lookback).limit(v1Request.limit).build();
    }

    static List<zipkin.Span> convert(List<Span> spans) {
        if (spans.isEmpty()) {
            return Collections.emptyList();
        }
        int length = spans.size();
        ArrayList<zipkin.Span> span1s = new ArrayList<zipkin.Span>(length);
        for (int i = 0; i < length; ++i) {
            span1s.add(V2SpanConverter.toSpan(spans.get(i)));
        }
        return span1s;
    }

    static /* synthetic */ List lambda$static$2(List spans) {
        List<zipkin.Span> span1s = V2SpanStoreAdapter.convert(spans);
        return span1s.isEmpty() ? null : span1s;
    }

    static /* synthetic */ List lambda$static$1(List spans) {
        List<zipkin.Span> span1s = CorrectForClockSkew.apply(MergeById.apply(V2SpanStoreAdapter.convert(spans)));
        return span1s.isEmpty() ? null : span1s;
    }

    static /* synthetic */ List lambda$static$0(List trace2s) {
        if (trace2s.isEmpty()) {
            return Collections.emptyList();
        }
        int length = trace2s.size();
        ArrayList<List<zipkin.Span>> trace1s = new ArrayList<List<zipkin.Span>>(length);
        for (int i = 0; i < length; ++i) {
            trace1s.add(CorrectForClockSkew.apply(MergeById.apply(V2SpanStoreAdapter.convert((List)trace2s.get(i)))));
        }
        Collections.sort(trace1s, GroupByTraceId.TRACE_DESCENDING);
        return trace1s;
    }
}

