/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.internal.Collector;
import zipkin.internal.Util;
import zipkin.internal.V2CallbackAdapter;
import zipkin.internal.V2StorageComponent;
import zipkin.internal.v2.Span;
import zipkin.internal.v2.codec.BytesDecoder;
import zipkin.storage.Callback;

public final class V2Collector
extends Collector<BytesDecoder<Span>, Span> {
    final V2StorageComponent storage;
    final CollectorSampler sampler;

    public V2Collector(Logger logger, @Nullable CollectorMetrics metrics, @Nullable CollectorSampler sampler, V2StorageComponent storage) {
        super(logger, metrics);
        this.storage = Util.checkNotNull(storage, "storage");
        this.sampler = sampler == null ? CollectorSampler.ALWAYS_SAMPLE : sampler;
    }

    @Override
    public void acceptSpans(byte[] serializedSpans, BytesDecoder<Span> decoder, Callback<Void> callback) {
        super.acceptSpans(serializedSpans, decoder, callback);
    }

    @Override
    protected List<Span> decodeList(BytesDecoder<Span> decoder, byte[] serialized) {
        return decoder.decodeList(serialized);
    }

    @Override
    protected boolean isSampled(Span span) {
        return this.sampler.isSampled(Util.lowerHexToUnsignedLong(span.traceId()), span.debug());
    }

    @Override
    protected void record(List<Span> sampled, Callback<Void> callback) {
        this.storage.v2SpanConsumer().accept(sampled).enqueue(new V2CallbackAdapter<Void>(callback));
    }

    @Override
    protected String idString(Span span) {
        return span.traceId() + "/" + span.id();
    }
}

