/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Codec;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.Base64;
import zipkin.internal.Buffer;
import zipkin.internal.JsonCodec$$Lambda$1;
import zipkin.internal.JsonCodec$$Lambda$2;
import zipkin.internal.JsonCodec$$Lambda$3;
import zipkin.internal.Util;
import zipkin.internal.gson.stream.JsonReader;
import zipkin.internal.gson.stream.JsonToken;
import zipkin.internal.gson.stream.MalformedJsonException;

public final class JsonCodec
implements Codec {
    static final long MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFFL;
    static final String ENDPOINT_HEADER = ",\"endpoint\":";
    static final JsonReaderAdapter<Endpoint> ENDPOINT_READER = JsonCodec$$Lambda$1.lambdaFactory$();
    static final Buffer.Writer<Endpoint> ENDPOINT_WRITER = new Buffer.Writer<Endpoint>(){

        @Override
        public int sizeInBytes(Endpoint value) {
            int sizeInBytes = 0;
            sizeInBytes += "{\"serviceName\":\"".length();
            sizeInBytes += Buffer.jsonEscapedSizeInBytes(value.serviceName) + 1;
            if (value.ipv4 != 0) {
                sizeInBytes += ",\"ipv4\":\"".length();
                sizeInBytes += Buffer.asciiSizeInBytes(value.ipv4 >> 24 & 0xFF) + 1;
                sizeInBytes += Buffer.asciiSizeInBytes(value.ipv4 >> 16 & 0xFF) + 1;
                sizeInBytes += Buffer.asciiSizeInBytes(value.ipv4 >> 8 & 0xFF) + 1;
                sizeInBytes += Buffer.asciiSizeInBytes(value.ipv4 & 0xFF) + 1;
            }
            if (value.port != null && value.port != 0) {
                sizeInBytes += ",\"port\":".length() + Buffer.asciiSizeInBytes(value.port & 0xFFFF);
            }
            if (value.ipv6 != null) {
                sizeInBytes += ",\"ipv6\":\"".length() + Buffer.ipv6SizeInBytes(value.ipv6) + 1;
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(Endpoint value, Buffer b) {
            b.writeAscii("{\"serviceName\":\"");
            b.writeJsonEscaped(value.serviceName).writeByte(34);
            if (value.ipv4 != 0) {
                b.writeAscii(",\"ipv4\":\"");
                b.writeAscii(value.ipv4 >> 24 & 0xFF).writeByte(46);
                b.writeAscii(value.ipv4 >> 16 & 0xFF).writeByte(46);
                b.writeAscii(value.ipv4 >> 8 & 0xFF).writeByte(46);
                b.writeAscii(value.ipv4 & 0xFF).writeByte(34);
            }
            if (value.port != null && value.port != 0) {
                b.writeAscii(",\"port\":").writeAscii((long)(value.port & 0xFFFF));
            }
            if (value.ipv6 != null) {
                b.writeAscii(",\"ipv6\":\"").writeIpV6(value.ipv6).writeByte(34);
            }
            b.writeByte(125);
        }
    };
    static final JsonReaderAdapter<Annotation> ANNOTATION_READER = JsonCodec$$Lambda$2.lambdaFactory$();
    static final Buffer.Writer<Annotation> ANNOTATION_WRITER = new Buffer.Writer<Annotation>(){

        @Override
        public int sizeInBytes(Annotation value) {
            int sizeInBytes = 0;
            sizeInBytes += "{\"timestamp\":".length() + Buffer.asciiSizeInBytes(value.timestamp);
            sizeInBytes += ",\"value\":\"".length() + Buffer.jsonEscapedSizeInBytes(value.value) + 1;
            if (value.endpoint != null) {
                sizeInBytes += JsonCodec.ENDPOINT_HEADER.length() + ENDPOINT_WRITER.sizeInBytes(value.endpoint);
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(Annotation value, Buffer b) {
            b.writeAscii("{\"timestamp\":").writeAscii(value.timestamp);
            b.writeAscii(",\"value\":\"").writeJsonEscaped(value.value).writeByte(34);
            if (value.endpoint != null) {
                b.writeAscii(JsonCodec.ENDPOINT_HEADER);
                ENDPOINT_WRITER.write(value.endpoint, b);
            }
            b.writeByte(125);
        }
    };
    static final JsonReaderAdapter<BinaryAnnotation> BINARY_ANNOTATION_READER = JsonCodec$$Lambda$3.lambdaFactory$();
    static final Buffer.Writer<BinaryAnnotation> BINARY_ANNOTATION_WRITER = new Buffer.Writer<BinaryAnnotation>(){

        @Override
        public int sizeInBytes(BinaryAnnotation value) {
            int sizeInBytes = 0;
            sizeInBytes += "{\"key\":\"".length() + Buffer.jsonEscapedSizeInBytes(value.key);
            sizeInBytes += "\",\"value\":".length();
            switch (value.type) {
                case BOOL: {
                    sizeInBytes += value.value[0] == 1 ? 4 : 5;
                    break;
                }
                case STRING: {
                    sizeInBytes += Buffer.jsonEscapedSizeInBytes(value.value) + 2;
                    break;
                }
                case BYTES: {
                    sizeInBytes += (value.value.length + 2) / 3 * 4 + 2;
                    break;
                }
                case I16: {
                    sizeInBytes += Buffer.asciiSizeInBytes(ByteBuffer.wrap(value.value).getShort());
                    break;
                }
                case I32: {
                    sizeInBytes += Buffer.asciiSizeInBytes(ByteBuffer.wrap(value.value).getInt());
                    break;
                }
                case I64: {
                    long number = ByteBuffer.wrap(value.value).getLong();
                    sizeInBytes += Buffer.asciiSizeInBytes(number);
                    if (number <= 0x1FFFFFFFFFFFFFL) break;
                    sizeInBytes += 2;
                    break;
                }
                case DOUBLE: {
                    double wrapped = Double.longBitsToDouble(ByteBuffer.wrap(value.value).getLong());
                    sizeInBytes += Double.toString(wrapped).length();
                    break;
                }
            }
            if (value.type != BinaryAnnotation.Type.STRING && value.type != BinaryAnnotation.Type.BOOL) {
                sizeInBytes += ",\"type\":\"".length() + Buffer.utf8SizeInBytes(value.type.name()) + 1;
            }
            if (value.endpoint != null) {
                sizeInBytes += JsonCodec.ENDPOINT_HEADER.length() + ENDPOINT_WRITER.sizeInBytes(value.endpoint);
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(BinaryAnnotation value, Buffer b) {
            b.writeAscii("{\"key\":\"").writeJsonEscaped(value.key);
            b.writeAscii("\",\"value\":");
            switch (value.type) {
                case BOOL: {
                    b.writeAscii(value.value[0] == 1 ? "true" : "false");
                    break;
                }
                case STRING: {
                    b.writeByte(34).writeJsonEscaped(value.value).writeByte(34);
                    break;
                }
                case BYTES: {
                    b.writeByte(34).writeAscii(Util.writeBase64Url(value.value)).writeByte(34);
                    break;
                }
                case I16: {
                    b.writeAscii(ByteBuffer.wrap(value.value).getShort());
                    break;
                }
                case I32: {
                    b.writeAscii(ByteBuffer.wrap(value.value).getInt());
                    break;
                }
                case I64: {
                    long number = ByteBuffer.wrap(value.value).getLong();
                    if (number > 0x1FFFFFFFFFFFFFL) {
                        b.writeByte(34);
                    }
                    b.writeAscii(number);
                    if (number <= 0x1FFFFFFFFFFFFFL) break;
                    b.writeByte(34);
                    break;
                }
                case DOUBLE: {
                    double wrapped = Double.longBitsToDouble(ByteBuffer.wrap(value.value).getLong());
                    b.writeAscii(Double.toString(wrapped));
                    break;
                }
            }
            if (value.type != BinaryAnnotation.Type.STRING && value.type != BinaryAnnotation.Type.BOOL) {
                b.writeAscii(",\"type\":\"").writeAscii(value.type.name()).writeByte(34);
            }
            if (value.endpoint != null) {
                b.writeAscii(JsonCodec.ENDPOINT_HEADER);
                ENDPOINT_WRITER.write(value.endpoint, b);
            }
            b.writeByte(125);
        }
    };
    static final Buffer.Writer<Span> SPAN_WRITER = new Buffer.Writer<Span>(){

        @Override
        public int sizeInBytes(Span value) {
            int sizeInBytes = 0;
            if (value.traceIdHigh != 0L) {
                sizeInBytes += 16;
            }
            sizeInBytes += "{\"traceId\":\"".length() + 16;
            sizeInBytes += "\",\"id\":\"".length() + 16;
            sizeInBytes += "\",\"name\":\"".length() + Buffer.jsonEscapedSizeInBytes(value.name) + 1;
            if (value.parentId != null) {
                sizeInBytes += ",\"parentId\":\"".length() + 16 + 1;
            }
            if (value.timestamp != null) {
                sizeInBytes += ",\"timestamp\":".length() + Buffer.asciiSizeInBytes(value.timestamp);
            }
            if (value.duration != null) {
                sizeInBytes += ",\"duration\":".length() + Buffer.asciiSizeInBytes(value.duration);
            }
            if (!value.annotations.isEmpty()) {
                sizeInBytes += ",\"annotations\":".length();
                sizeInBytes += JsonCodec.sizeInBytes(ANNOTATION_WRITER, value.annotations);
            }
            if (!value.binaryAnnotations.isEmpty()) {
                sizeInBytes += ",\"binaryAnnotations\":".length();
                sizeInBytes += JsonCodec.sizeInBytes(BINARY_ANNOTATION_WRITER, value.binaryAnnotations);
            }
            if (value.debug != null && value.debug.booleanValue()) {
                sizeInBytes += ",\"debug\":true".length();
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(Span value, Buffer b) {
            b.writeAscii("{\"traceId\":\"");
            if (value.traceIdHigh != 0L) {
                b.writeLowerHex(value.traceIdHigh);
            }
            b.writeLowerHex(value.traceId);
            b.writeAscii("\",\"id\":\"").writeLowerHex(value.id);
            b.writeAscii("\",\"name\":\"").writeJsonEscaped(value.name).writeByte(34);
            if (value.parentId != null) {
                b.writeAscii(",\"parentId\":\"").writeLowerHex(value.parentId).writeByte(34);
            }
            if (value.timestamp != null) {
                b.writeAscii(",\"timestamp\":").writeAscii(value.timestamp);
            }
            if (value.duration != null) {
                b.writeAscii(",\"duration\":").writeAscii(value.duration);
            }
            if (!value.annotations.isEmpty()) {
                b.writeAscii(",\"annotations\":");
                JsonCodec.writeList(ANNOTATION_WRITER, value.annotations, b);
            }
            if (!value.binaryAnnotations.isEmpty()) {
                b.writeAscii(",\"binaryAnnotations\":");
                JsonCodec.writeList(BINARY_ANNOTATION_WRITER, value.binaryAnnotations, b);
            }
            if (value.debug != null && value.debug.booleanValue()) {
                b.writeAscii(",\"debug\":true");
            }
            b.writeByte(125);
        }

        public String toString() {
            return "Span";
        }
    };
    static final JsonReaderAdapter<DependencyLink> DEPENDENCY_LINK_READER = new JsonReaderAdapter<DependencyLink>(){

        @Override
        public DependencyLink fromJson(JsonReader reader) throws IOException {
            DependencyLink.Builder result = DependencyLink.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("parent")) {
                    result.parent(reader.nextString());
                    continue;
                }
                if (nextName.equals("child")) {
                    result.child(reader.nextString());
                    continue;
                }
                if (nextName.equals("callCount")) {
                    result.callCount(reader.nextLong());
                    continue;
                }
                if (nextName.equals("errorCount")) {
                    result.errorCount(reader.nextLong());
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        public String toString() {
            return "DependencyLink";
        }
    };
    static final Buffer.Writer<DependencyLink> DEPENDENCY_LINK_WRITER = new Buffer.Writer<DependencyLink>(){

        @Override
        public int sizeInBytes(DependencyLink value) {
            int sizeInBytes = 0;
            sizeInBytes += "{\"parent\":\"".length() + Buffer.jsonEscapedSizeInBytes(value.parent);
            sizeInBytes += "\",\"child\":\"".length() + Buffer.jsonEscapedSizeInBytes(value.child);
            sizeInBytes += "\",\"callCount\":".length() + Buffer.asciiSizeInBytes(value.callCount);
            if (value.errorCount > 0L) {
                sizeInBytes += ",\"errorCount\":".length() + Buffer.asciiSizeInBytes(value.errorCount);
            }
            return ++sizeInBytes;
        }

        @Override
        public void write(DependencyLink value, Buffer b) {
            b.writeAscii("{\"parent\":\"").writeJsonEscaped(value.parent);
            b.writeAscii("\",\"child\":\"").writeJsonEscaped(value.child);
            b.writeAscii("\",\"callCount\":").writeAscii(value.callCount);
            if (value.errorCount > 0L) {
                b.writeAscii(",\"errorCount\":").writeAscii(value.errorCount);
            }
            b.writeByte(125);
        }

        public String toString() {
            return "DependencyLink";
        }
    };
    static final JsonReaderAdapter<String> STRING_READER = new JsonReaderAdapter<String>(){

        @Override
        public String fromJson(JsonReader reader) throws IOException {
            return reader.nextString();
        }

        public String toString() {
            return "String";
        }
    };
    static final Buffer.Writer<String> STRING_WRITER = new Buffer.Writer<String>(){

        @Override
        public int sizeInBytes(String value) {
            return Buffer.jsonEscapedSizeInBytes(value) + 2;
        }

        @Override
        public void write(String value, Buffer buffer) {
            buffer.writeByte(34).writeJsonEscaped(value).writeByte(34);
        }

        public String toString() {
            return "String";
        }
    };

    @Override
    public Span readSpan(byte[] bytes) {
        return JsonCodec.read(new SpanReader(), bytes);
    }

    @Override
    public int sizeInBytes(Span value) {
        return SPAN_WRITER.sizeInBytes(value);
    }

    @Override
    public byte[] writeSpan(Span value) {
        return JsonCodec.write(SPAN_WRITER, value);
    }

    public static byte[] writeEndpoint(Endpoint value) {
        return JsonCodec.write(ENDPOINT_WRITER, value);
    }

    public static byte[] writeAnnotation(Annotation value) {
        return JsonCodec.write(ANNOTATION_WRITER, value);
    }

    public static byte[] writeBinaryAnnotation(BinaryAnnotation value) {
        return JsonCodec.write(BINARY_ANNOTATION_WRITER, value);
    }

    public static String escape(String value) {
        return Buffer.jsonEscape(value);
    }

    @Override
    public List<Span> readSpans(byte[] bytes) {
        return JsonCodec.readList(new SpanReader(), bytes);
    }

    @Override
    public byte[] writeSpans(List<Span> value) {
        return JsonCodec.writeList(SPAN_WRITER, value);
    }

    @Override
    public byte[] writeTraces(List<List<Span>> traces) {
        return JsonCodec.writeNestedList(SPAN_WRITER, traces);
    }

    public static <T> byte[] writeNestedList(Buffer.Writer<T> writer, List<List<T>> traces) {
        int sizeInBytes = JsonCodec.overheadInBytes(traces);
        int length = traces.size();
        for (int i = 0; i < length; ++i) {
            List<T> spans = traces.get(i);
            sizeInBytes += JsonCodec.overheadInBytes(spans);
            int jLength = spans.size();
            for (int j = 0; j < jLength; ++j) {
                sizeInBytes += writer.sizeInBytes(spans.get(j));
            }
        }
        Buffer out = new Buffer(sizeInBytes);
        out.writeByte(91);
        int length2 = traces.size();
        for (int i = 0; i < length2; ++i) {
            JsonCodec.writeList(writer, traces.get(i), out);
            if (i + 1 >= length2) continue;
            out.writeByte(44);
        }
        out.writeByte(93);
        return out.toByteArray();
    }

    public List<List<Span>> readTraces(byte[] bytes) {
        return JsonCodec.readList(new SpanListReader(), bytes);
    }

    @Override
    public DependencyLink readDependencyLink(byte[] bytes) {
        return JsonCodec.read(DEPENDENCY_LINK_READER, bytes);
    }

    @Override
    public byte[] writeDependencyLink(DependencyLink value) {
        return JsonCodec.write(DEPENDENCY_LINK_WRITER, value);
    }

    @Override
    public List<DependencyLink> readDependencyLinks(byte[] bytes) {
        return JsonCodec.readList(DEPENDENCY_LINK_READER, bytes);
    }

    @Override
    public byte[] writeDependencyLinks(List<DependencyLink> value) {
        return JsonCodec.writeList(DEPENDENCY_LINK_WRITER, value);
    }

    public List<String> readStrings(byte[] bytes) {
        return JsonCodec.readList(STRING_READER, bytes);
    }

    public byte[] writeStrings(List<String> value) {
        return JsonCodec.writeList(STRING_WRITER, value);
    }

    public static <T> T read(JsonReaderAdapter<T> adapter, byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading %s", adapter);
        try {
            return adapter.fromJson(JsonCodec.jsonReader(bytes));
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading(adapter.toString(), bytes, e);
        }
    }

    public static <T> List<T> readList(JsonReaderAdapter<T> adapter, byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading List<%s>", adapter);
        JsonReader reader = JsonCodec.jsonReader(bytes);
        try {
            LinkedList<T> result;
            reader.beginArray();
            LinkedList<T> linkedList = result = reader.hasNext() ? new LinkedList<T>() : Collections.emptyList();
            while (reader.hasNext()) {
                result.add(adapter.fromJson(reader));
            }
            reader.endArray();
            return result;
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading("List<" + adapter + ">", bytes, e);
        }
    }

    static JsonReader jsonReader(byte[] bytes) {
        return new JsonReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Util.UTF_8));
    }

    public static <T> byte[] write(Buffer.Writer<T> writer, T value) {
        Buffer b = new Buffer(writer.sizeInBytes(value));
        try {
            writer.write(value, b);
        }
        catch (RuntimeException e) {
            byte[] bytesWritten;
            byte[] bytes = b.toByteArray();
            int lengthWritten = bytes.length;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                lengthWritten = i;
                break;
            }
            if (lengthWritten == bytes.length) {
                bytesWritten = bytes;
            } else {
                bytesWritten = new byte[lengthWritten];
                System.arraycopy(bytes, 0, bytesWritten, 0, lengthWritten);
            }
            String written = new String(bytesWritten, Util.UTF_8);
            String message = String.format("Bug found using %s to write %s as json. Wrote %s/%s bytes: %s", writer.getClass().getSimpleName(), value.getClass().getSimpleName(), lengthWritten, bytes.length, written);
            throw Util.assertionError(message, e);
        }
        return b.toByteArray();
    }

    static <T> int sizeInBytes(Buffer.Writer<T> writer, List<T> value) {
        int sizeInBytes = JsonCodec.overheadInBytes(value);
        int length = value.size();
        for (int i = 0; i < length; ++i) {
            sizeInBytes += writer.sizeInBytes(value.get(i));
        }
        return sizeInBytes;
    }

    static <T> int overheadInBytes(List<T> value) {
        int sizeInBytes = 2;
        if (value.size() > 1) {
            sizeInBytes += value.size() - 1;
        }
        return sizeInBytes;
    }

    public static <T> byte[] writeList(Buffer.Writer<T> writer, List<T> value) {
        if (value.isEmpty()) {
            return new byte[]{91, 93};
        }
        Buffer result = new Buffer(JsonCodec.sizeInBytes(writer, value));
        JsonCodec.writeList(writer, value, result);
        return result.toByteArray();
    }

    public static <T> void writeList(Buffer.Writer<T> writer, List<T> value, Buffer b) {
        b.writeByte(91);
        int i = 0;
        int length = value.size();
        while (i < length) {
            writer.write(value.get(i++), b);
            if (i >= length) continue;
            b.writeByte(44);
        }
        b.writeByte(93);
    }

    static IllegalArgumentException exceptionReading(String type, byte[] bytes, Exception e) {
        String cause;
        String string = cause = e.getMessage() == null ? "Error" : e.getMessage();
        if (cause.indexOf("malformed") != -1) {
            cause = "Malformed";
        }
        String message = String.format("%s reading %s from json: %s", cause, type, new String(bytes, Util.UTF_8));
        throw new IllegalArgumentException(message, e);
    }

    static /* synthetic */ BinaryAnnotation lambda$static$2(JsonReader reader) throws IOException {
        byte[] value;
        BinaryAnnotation.Builder result = BinaryAnnotation.builder();
        String key = null;
        BinaryAnnotation.Type type = BinaryAnnotation.Type.STRING;
        boolean valueSet = false;
        String number = null;
        String string = null;
        reader.beginObject();
        block10: while (reader.hasNext()) {
            String nextName = reader.nextName();
            if (nextName.equals("key")) {
                key = reader.nextString();
                result.key(key);
                continue;
            }
            if (nextName.equals("value")) {
                valueSet = true;
                switch (reader.peek()) {
                    case BOOLEAN: {
                        byte[] byArray;
                        type = BinaryAnnotation.Type.BOOL;
                        if (reader.nextBoolean()) {
                            byte[] byArray2 = new byte[1];
                            byArray = byArray2;
                            byArray2[0] = 1;
                        } else {
                            byte[] byArray3 = new byte[1];
                            byArray = byArray3;
                            byArray3[0] = 0;
                        }
                        result.value(byArray);
                        continue block10;
                    }
                    case STRING: {
                        string = reader.nextString();
                        continue block10;
                    }
                    case NUMBER: {
                        number = reader.nextString();
                        continue block10;
                    }
                }
                throw new MalformedJsonException("Expected value to be a boolean, string or number but was " + (Object)((Object)reader.peek()) + " at path " + reader.getPath());
            }
            if (nextName.equals("type")) {
                type = BinaryAnnotation.Type.valueOf(reader.nextString());
                continue;
            }
            if (nextName.equals("endpoint") && reader.peek() != JsonToken.NULL) {
                result.endpoint(ENDPOINT_READER.fromJson(reader));
                continue;
            }
            reader.skipValue();
        }
        if (key == null) {
            throw new MalformedJsonException("No key at " + reader.getPath());
        }
        if (!valueSet) {
            throw new MalformedJsonException("No value for key " + key + " at " + reader.getPath());
        }
        reader.endObject();
        result.type(type);
        switch (type) {
            case BOOL: {
                return result.build();
            }
            case STRING: {
                return result.value(string.getBytes(Util.UTF_8)).build();
            }
            case BYTES: {
                return result.value(Base64.decode(string)).build();
            }
        }
        if (type == BinaryAnnotation.Type.I16) {
            short v = Short.parseShort(number);
            value = ByteBuffer.allocate(2).putShort(0, v).array();
        } else if (type == BinaryAnnotation.Type.I32) {
            int v = Integer.parseInt(number);
            value = ByteBuffer.allocate(4).putInt(0, v).array();
        } else if (type == BinaryAnnotation.Type.I64 || type == BinaryAnnotation.Type.DOUBLE) {
            if (number == null) {
                number = string;
            }
            long v = type == BinaryAnnotation.Type.I64 ? Long.parseLong(number) : Double.doubleToRawLongBits(Double.parseDouble(number));
            value = ByteBuffer.allocate(8).putLong(0, v).array();
        } else {
            throw new AssertionError((Object)("BinaryAnnotationType " + (Object)((Object)type) + " was added, but not handled"));
        }
        return result.value(value).build();
    }

    static /* synthetic */ Annotation lambda$static$1(JsonReader reader) throws IOException {
        Annotation.Builder result = Annotation.builder();
        reader.beginObject();
        while (reader.hasNext()) {
            String nextName = reader.nextName();
            if (nextName.equals("timestamp")) {
                result.timestamp(reader.nextLong());
                continue;
            }
            if (nextName.equals("value")) {
                result.value(reader.nextString());
                continue;
            }
            if (nextName.equals("endpoint") && reader.peek() != JsonToken.NULL) {
                result.endpoint(ENDPOINT_READER.fromJson(reader));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return result.build();
    }

    static /* synthetic */ Endpoint lambda$static$0(JsonReader reader) throws IOException {
        Endpoint.Builder result = Endpoint.builder();
        reader.beginObject();
        while (reader.hasNext()) {
            String nextName = reader.nextName();
            if (nextName.equals("serviceName")) {
                result.serviceName(reader.nextString());
                continue;
            }
            if (nextName.equals("ipv4") || nextName.equals("ipv6")) {
                result.parseIp(reader.nextString());
                continue;
            }
            if (nextName.equals("port")) {
                result.port(reader.nextInt());
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return result.build();
    }

    public static interface JsonReaderAdapter<T> {
        public T fromJson(JsonReader var1) throws IOException;
    }

    static final class SpanListReader
    implements JsonReaderAdapter<List<Span>> {
        SpanReader spanReader;

        SpanListReader() {
        }

        @Override
        public List<Span> fromJson(JsonReader reader) throws IOException {
            reader.beginArray();
            if (!reader.hasNext()) {
                reader.endArray();
                return Collections.emptyList();
            }
            LinkedList<Span> result = new LinkedList<Span>();
            if (this.spanReader == null) {
                this.spanReader = new SpanReader();
            }
            while (reader.hasNext()) {
                result.add(this.spanReader.fromJson(reader));
            }
            reader.endArray();
            return result;
        }

        public String toString() {
            return "List<Span>";
        }
    }

    static final class SpanReader
    implements JsonReaderAdapter<Span> {
        Span.Builder builder;

        SpanReader() {
        }

        @Override
        public Span fromJson(JsonReader reader) throws IOException {
            if (this.builder == null) {
                this.builder = Span.builder();
            } else {
                this.builder.clear();
            }
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("traceId")) {
                    String traceId = reader.nextString();
                    if (traceId.length() == 32) {
                        this.builder.traceIdHigh(Util.lowerHexToUnsignedLong(traceId, 0));
                    }
                    this.builder.traceId(Util.lowerHexToUnsignedLong(traceId));
                    continue;
                }
                if (nextName.equals("name")) {
                    this.builder.name(reader.nextString());
                    continue;
                }
                if (nextName.equals("id")) {
                    this.builder.id(Util.lowerHexToUnsignedLong(reader.nextString()));
                    continue;
                }
                if (nextName.equals("parentId") && reader.peek() != JsonToken.NULL) {
                    this.builder.parentId(Util.lowerHexToUnsignedLong(reader.nextString()));
                    continue;
                }
                if (nextName.equals("timestamp") && reader.peek() != JsonToken.NULL) {
                    this.builder.timestamp(reader.nextLong());
                    continue;
                }
                if (nextName.equals("duration") && reader.peek() != JsonToken.NULL) {
                    this.builder.duration(reader.nextLong());
                    continue;
                }
                if (nextName.equals("annotations")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        this.builder.addAnnotation(ANNOTATION_READER.fromJson(reader));
                    }
                    reader.endArray();
                    continue;
                }
                if (nextName.equals("binaryAnnotations")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        this.builder.addBinaryAnnotation(BINARY_ANNOTATION_READER.fromJson(reader));
                    }
                    reader.endArray();
                    continue;
                }
                if (nextName.equals("debug") && reader.peek() != JsonToken.NULL) {
                    if (!reader.nextBoolean()) continue;
                    this.builder.debug(true);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return this.builder.build();
        }

        public String toString() {
            return "Span";
        }
    }
}

