/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector;

import javax.annotation.Nullable;
import zipkin.Span;
import zipkin.internal.Util;

public abstract class CollectorSampler {
    public static final CollectorSampler ALWAYS_SAMPLE = CollectorSampler.create(1.0f);

    public static CollectorSampler create(float rate) {
        Util.checkArgument(rate >= 0.0f && rate <= 1.0f, "rate should be between 0 and 1: was %s", Float.valueOf(rate));
        final long boundary = (long)(9.223372E18f * rate);
        return new CollectorSampler(){

            @Override
            protected long boundary() {
                return boundary;
            }
        };
    }

    protected abstract long boundary();

    public boolean isSampled(long traceId, @Nullable Boolean debug) {
        if (Boolean.TRUE.equals(debug)) {
            return true;
        }
        long t = traceId == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(traceId);
        return t <= this.boundary();
    }

    @Deprecated
    public boolean isSampled(Span span) {
        return this.isSampled(span.traceId, span.debug);
    }

    public String toString() {
        return "CollectorSampler(" + this.boundary() + ")";
    }

    protected CollectorSampler() {
    }
}

