/*
 * Decompiled with CFR 0.152.
 */
package zipkin.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import zipkin.Span;
import zipkin.SpanDecoder;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.internal.DetectingSpanDecoder;
import zipkin.internal.Util;
import zipkin.internal.V2Collector;
import zipkin.internal.V2JsonSpanDecoder;
import zipkin.internal.V2SpanConverter;
import zipkin.internal.V2StorageComponent;
import zipkin.internal.v2.codec.BytesDecoder;
import zipkin.storage.Callback;
import zipkin.storage.StorageComponent;

public class Collector
extends zipkin.internal.Collector<SpanDecoder, Span> {
    final CollectorSampler sampler;
    final StorageComponent storage;
    final V2Collector storage2;

    public static Builder builder(Class<?> loggingClass) {
        return new Builder(Logger.getLogger(Util.checkNotNull(loggingClass, "loggingClass").getName()));
    }

    Collector(Builder builder) {
        super(builder.logger, builder.metrics);
        this.storage = Util.checkNotNull(builder.storage, "storage");
        this.sampler = builder.sampler == null ? CollectorSampler.ALWAYS_SAMPLE : builder.sampler;
        this.storage2 = this.storage instanceof V2StorageComponent ? new V2Collector(builder.logger, builder.metrics, builder.sampler, (V2StorageComponent)this.storage) : null;
    }

    @Override
    public void acceptSpans(byte[] serializedSpans, SpanDecoder decoder, Callback<Void> callback) {
        try {
            if (decoder instanceof DetectingSpanDecoder) {
                decoder = DetectingSpanDecoder.detectFormat(serializedSpans);
            }
        }
        catch (RuntimeException e) {
            this.metrics.incrementBytes(serializedSpans.length);
            callback.onError(this.errorReading(e));
            return;
        }
        if (this.storage2 != null && decoder instanceof V2JsonSpanDecoder) {
            this.storage2.acceptSpans(serializedSpans, BytesDecoder.JSON, callback);
        } else {
            super.acceptSpans(serializedSpans, decoder, callback);
        }
    }

    @Deprecated
    public void acceptSpans(List<byte[]> serializedSpans, SpanDecoder decoder, Callback<Void> callback) {
        ArrayList<Span> spans = new ArrayList<Span>(serializedSpans.size());
        try {
            int bytesRead = 0;
            for (byte[] serializedSpan : serializedSpans) {
                bytesRead += serializedSpan.length;
                spans.add(decoder.readSpan(serializedSpan));
            }
            this.metrics.incrementBytes(bytesRead);
        }
        catch (RuntimeException e) {
            callback.onError(this.errorReading(e));
            return;
        }
        this.accept((List<Span>)spans, callback);
    }

    @Override
    public void accept(List<Span> spans, Callback<Void> callback) {
        if (this.storage2 != null) {
            int length = spans.size();
            ArrayList<zipkin.internal.v2.Span> span2s = new ArrayList<zipkin.internal.v2.Span>(length);
            for (int i = 0; i < length; ++i) {
                span2s.addAll(V2SpanConverter.fromSpan(spans.get(i)));
            }
            this.storage2.accept(span2s, callback);
        } else {
            super.accept(spans, callback);
        }
    }

    @Override
    protected List<Span> decodeList(SpanDecoder decoder, byte[] serialized) {
        return decoder.readSpans(serialized);
    }

    @Override
    protected boolean isSampled(Span span) {
        return this.sampler.isSampled(span.traceId, span.debug);
    }

    @Override
    protected void record(List<Span> sampled, Callback<Void> callback) {
        this.storage.asyncSpanConsumer().accept(sampled, callback);
    }

    @Override
    protected String idString(Span span) {
        return span.idString();
    }

    public static final class Builder {
        final Logger logger;
        StorageComponent storage = null;
        CollectorSampler sampler = null;
        CollectorMetrics metrics = null;

        Builder(Logger logger) {
            this.logger = logger;
        }

        public Builder storage(StorageComponent storage) {
            this.storage = Util.checkNotNull(storage, "storage");
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            this.metrics = Util.checkNotNull(metrics, "metrics");
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            this.sampler = Util.checkNotNull(sampler, "sampler");
            return this;
        }

        public Collector build() {
            return new Collector(this);
        }
    }
}

