/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import zipkin.Span;
import zipkin.internal.Nullable;

public final class Node<V> {
    private Node<V> parent;
    private V value;
    private List<Node<V>> children = Collections.emptyList();
    private boolean missingRootDummyNode;

    @Nullable
    public Node<V> parent() {
        return this.parent;
    }

    public V value() {
        return this.value;
    }

    public Node<V> value(V newValue) {
        this.value = newValue;
        return this;
    }

    public Node<V> addChild(Node<V> child) {
        child.parent = this;
        if (this.children.equals(Collections.emptyList())) {
            this.children = new LinkedList<Node<V>>();
        }
        this.children.add(child);
        return this;
    }

    public Collection<Node<V>> children() {
        return this.children;
    }

    public Iterator<Node<V>> traverse() {
        return new BreadthFirstIterator(this);
    }

    public boolean isSyntheticRootForPartialTree() {
        return this.missingRootDummyNode;
    }

    static Node<Span> constructTree(List<Span> trace) {
        TreeBuilder<Span> treeBuilder = new TreeBuilder<Span>();
        for (Span s : trace) {
            treeBuilder.addNode(s.parentId, s.id, s);
        }
        return treeBuilder.build();
    }

    public static final class TreeBuilder<V> {
        Node<V> rootNode = null;
        Map<Long, Node<V>> idToNode = new LinkedHashMap<Long, Node<V>>();
        Map<Long, Long> idToParent = new LinkedHashMap<Long, Long>(this.idToNode.size());

        public void addNode(Long parentId, long id, @Nullable V value) {
            Node node = new Node<V>().value(value);
            if (parentId == null) {
                if (this.rootNode == null) {
                    this.rootNode = node;
                } else {
                    this.idToNode.put(id, node);
                    this.idToParent.put(id, null);
                }
            } else {
                this.idToNode.put(id, node);
                this.idToParent.put(id, parentId);
            }
        }

        public Node<V> build() {
            for (Map.Entry<Long, Long> entry : this.idToParent.entrySet()) {
                Node<V> node = this.idToNode.get(entry.getKey());
                Node<V> parent = this.idToNode.get(entry.getValue());
                if (parent == null) {
                    if (this.rootNode == null) {
                        this.rootNode = new Node();
                        ((Node)this.rootNode).missingRootDummyNode = true;
                    }
                    this.rootNode.addChild(node);
                    continue;
                }
                parent.addChild(node);
            }
            return this.rootNode != null ? this.rootNode : new Node();
        }
    }

    static final class BreadthFirstIterator<V>
    implements Iterator<Node<V>> {
        private final Queue<Node<V>> queue = new ArrayDeque<Node<V>>();

        BreadthFirstIterator(Node<V> root) {
            this.queue.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Node<V> next() {
            Node<V> result = this.queue.remove();
            this.queue.addAll(((Node)result).children);
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

