/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import zipkin.internal.Util;

final class Buffer {
    private final byte[] buf;
    private int pos;
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String U2028 = "\\u2028";
    private static final String U2029 = "\\u2029";
    private static final ThreadLocal<Buffer> IPV6_SIZE;
    static final byte[] HEX_DIGITS;
    static final byte[] URL_MAP;

    Buffer(int size) {
        this.buf = new byte[size];
    }

    Buffer writeByte(int v) {
        this.buf[this.pos++] = (byte)v;
        return this;
    }

    Buffer write(byte[] v) {
        System.arraycopy(v, 0, this.buf, this.pos, v.length);
        this.pos += v.length;
        return this;
    }

    Buffer writeShort(int v) {
        this.writeByte(v >>> 8 & 0xFF);
        this.writeByte(v & 0xFF);
        return this;
    }

    Buffer writeInt(int v) {
        this.buf[this.pos++] = (byte)(v >>> 24 & 0xFF);
        this.buf[this.pos++] = (byte)(v >>> 16 & 0xFF);
        this.buf[this.pos++] = (byte)(v >>> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(v & 0xFF);
        return this;
    }

    Buffer writeLong(long v) {
        this.buf[this.pos++] = (byte)(v >>> 56 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 48 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 40 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 32 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 24 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 16 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >>> 8 & 0xFFL);
        this.buf[this.pos++] = (byte)(v & 0xFFL);
        return this;
    }

    static int asciiSizeInBytes(String string) {
        return string.length();
    }

    static int utf8SizeInBytes(String string) {
        int sizeInBytes = 0;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char low;
            char ch = string.charAt(i);
            if (ch < '\u0080') {
                ++sizeInBytes;
                continue;
            }
            if (ch < '\u0800') {
                sizeInBytes += 2;
                continue;
            }
            if (ch < '\ud800' || ch > '\udfff') {
                sizeInBytes += 3;
                continue;
            }
            char c = low = i + 1 < len ? string.charAt(i + 1) : (char)'\u0000';
            if (ch > '\udbff' || low < '\udc00' || low > '\udfff') {
                ++sizeInBytes;
                continue;
            }
            sizeInBytes += 4;
            ++i;
        }
        return sizeInBytes;
    }

    Buffer writeLengthPrefixed(String v) {
        boolean ascii = Buffer.isAscii(v);
        if (ascii) {
            this.writeInt(v.length());
            return this.writeAscii(v);
        }
        byte[] temp = v.getBytes(Util.UTF_8);
        this.writeInt(temp.length);
        this.write(temp);
        return this;
    }

    Buffer writeAscii(String v) {
        int length = v.length();
        for (int i = 0; i < length; ++i) {
            this.buf[this.pos++] = (byte)v.charAt(i);
        }
        return this;
    }

    static boolean isAscii(String v) {
        int length = v.length();
        for (int i = 0; i < length; ++i) {
            if (v.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    static boolean needsJsonEscaping(byte[] v) {
        for (int i = 0; i < v.length; ++i) {
            int current = v[i] & 0xFF;
            if (i >= 2 && (current == 168 || current == 169) && (v[i - 1] & 0xFF) == 128 && (v[i - 2] & 0xFF) == 226) {
                return true;
            }
            if (current >= 128 || REPLACEMENT_CHARS[current] == null) continue;
            return true;
        }
        return false;
    }

    static int jsonEscapedSizeInBytes(byte[] v) {
        return Buffer.needsJsonEscaping(v) ? Buffer.jsonEscapedSizeInBytes(new String(v, Util.UTF_8)) : v.length;
    }

    static int jsonEscapedSizeInBytes(String v) {
        boolean ascii = true;
        int escapingOverhead = 0;
        int length = v.length();
        for (int i = 0; i < length; ++i) {
            char c = v.charAt(i);
            if (c == '\u2028' || c == '\u2029') {
                escapingOverhead += 5;
                continue;
            }
            if (c >= '\u0080') {
                ascii = false;
                continue;
            }
            String maybeReplacement = REPLACEMENT_CHARS[c];
            if (maybeReplacement == null) continue;
            escapingOverhead += maybeReplacement.length() - 1;
        }
        if (ascii) {
            return Buffer.asciiSizeInBytes(v) + escapingOverhead;
        }
        return Buffer.utf8SizeInBytes(v) + escapingOverhead;
    }

    Buffer writeJsonEscaped(byte[] v) {
        return Buffer.needsJsonEscaping(v) ? this.writeJsonEscaped(new String(v, Util.UTF_8)) : this.write(v);
    }

    Buffer writeJsonEscaped(String v) {
        int afterReplacement = 0;
        int length = v.length();
        StringBuilder builder = null;
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = v.charAt(i);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = U2028;
            } else {
                if (c != '\u2029') continue;
                replacement = U2029;
            }
            if (afterReplacement < i) {
                if (builder == null) {
                    builder = new StringBuilder();
                }
                builder.append(v, afterReplacement, i);
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(replacement);
            afterReplacement = i + 1;
        }
        if (builder == null) {
            return this.writeUtf8(v);
        }
        if (afterReplacement < length) {
            builder.append(v, afterReplacement, length);
        }
        return this.writeUtf8(builder.toString());
    }

    Buffer writeUtf8(String v) {
        if (Buffer.isAscii(v)) {
            return this.writeAscii(v);
        }
        byte[] temp = v.getBytes(Util.UTF_8);
        this.write(temp);
        return this;
    }

    Buffer writeLowerHex(long v) {
        this.writeHexByte((byte)(v >>> 56 & 0xFFL));
        this.writeHexByte((byte)(v >>> 48 & 0xFFL));
        this.writeHexByte((byte)(v >>> 40 & 0xFFL));
        this.writeHexByte((byte)(v >>> 32 & 0xFFL));
        this.writeHexByte((byte)(v >>> 24 & 0xFFL));
        this.writeHexByte((byte)(v >>> 16 & 0xFFL));
        this.writeHexByte((byte)(v >>> 8 & 0xFFL));
        this.writeHexByte((byte)(v & 0xFFL));
        return this;
    }

    static int ipv6SizeInBytes(byte[] ipv6) {
        int result = Buffer.IPV6_SIZE.get().writeIpV6((byte[])ipv6).pos;
        Buffer.IPV6_SIZE.get().pos = 0;
        return result;
    }

    Buffer writeIpV6(byte[] ipv6) {
        int i;
        int zeroCompressionIndex = -1;
        int zeroCompressionLength = -1;
        int zeroIndex = -1;
        boolean allZeros = true;
        for (i = 0; i < ipv6.length; i += 2) {
            if (ipv6[i] == 0 && ipv6[i + 1] == 0) {
                if (zeroIndex >= 0) continue;
                zeroIndex = i;
                continue;
            }
            allZeros = false;
            if (zeroIndex < 0) continue;
            int zeroLength = i - zeroIndex;
            if (zeroLength > zeroCompressionLength) {
                zeroCompressionIndex = zeroIndex;
                zeroCompressionLength = zeroLength;
            }
            zeroIndex = -1;
        }
        if (allZeros) {
            this.buf[this.pos++] = 58;
            this.buf[this.pos++] = 58;
            return this;
        }
        if (zeroCompressionIndex == -1 && zeroIndex != -1) {
            zeroCompressionIndex = zeroIndex;
            zeroCompressionLength = 16 - zeroIndex;
        }
        i = 0;
        while (i < ipv6.length) {
            if (i == zeroCompressionIndex) {
                this.buf[this.pos++] = 58;
                if ((i += zeroCompressionLength) != ipv6.length) continue;
                this.buf[this.pos++] = 58;
                continue;
            }
            if (i != 0) {
                this.buf[this.pos++] = 58;
            }
            byte high = ipv6[i++];
            byte low = ipv6[i++];
            byte val = HEX_DIGITS[high >> 4 & 0xF];
            boolean leadingZero = val == 48;
            if (!leadingZero) {
                this.buf[this.pos++] = val;
            }
            val = HEX_DIGITS[high & 0xF];
            if (!(leadingZero = leadingZero && val == 48)) {
                this.buf[this.pos++] = val;
            }
            val = HEX_DIGITS[low >> 4 & 0xF];
            if (!leadingZero || val != 48) {
                this.buf[this.pos++] = val;
            }
            this.buf[this.pos++] = HEX_DIGITS[low & 0xF];
        }
        return this;
    }

    static int asciiSizeInBytes(long v) {
        if (v == 0L) {
            return 1;
        }
        if (v == Long.MIN_VALUE) {
            return 20;
        }
        boolean negative = false;
        if (v < 0L) {
            v = -v;
            negative = true;
        }
        int width = v < 100000000L ? (v < 10000L ? (v < 100L ? (v < 10L ? 1 : 2) : (v < 1000L ? 3 : 4)) : (v < 1000000L ? (v < 100000L ? 5 : 6) : (v < 10000000L ? 7 : 8))) : (v < 1000000000000L ? (v < 10000000000L ? (v < 1000000000L ? 9 : 10) : (v < 100000000000L ? 11 : 12)) : (v < 1000000000000000L ? (v < 10000000000000L ? 13 : (v < 100000000000000L ? 14 : 15)) : (v < 100000000000000000L ? (v < 10000000000000000L ? 16 : 17) : (v < 1000000000000000000L ? 18 : 19))));
        return negative ? width + 1 : width;
    }

    Buffer writeAscii(long v) {
        if (v == 0L) {
            return this.writeByte(48);
        }
        if (v == Long.MIN_VALUE) {
            return this.writeAscii("-9223372036854775808");
        }
        int width = Buffer.asciiSizeInBytes(v);
        int pos = this.pos += width;
        boolean negative = false;
        if (v < 0L) {
            negative = true;
            v = -v;
        }
        while (v != 0L) {
            int digit = (int)(v % 10L);
            this.buf[--pos] = HEX_DIGITS[digit];
            v /= 10L;
        }
        if (negative) {
            this.buf[--pos] = 45;
        }
        return this;
    }

    void writeHexByte(byte b) {
        this.buf[this.pos++] = HEX_DIGITS[b >> 4 & 0xF];
        this.buf[this.pos++] = HEX_DIGITS[b & 0xF];
    }

    static int base64UrlSizeInBytes(byte[] in) {
        return (in.length + 2) / 3 * 4;
    }

    Buffer writeBase64Url(byte[] in) {
        int end = in.length - in.length % 3;
        for (int i = 0; i < end; i += 3) {
            this.buf[this.pos++] = URL_MAP[(in[i] & 0xFF) >> 2];
            this.buf[this.pos++] = URL_MAP[(in[i] & 3) << 4 | (in[i + 1] & 0xFF) >> 4];
            this.buf[this.pos++] = URL_MAP[(in[i + 1] & 0xF) << 2 | (in[i + 2] & 0xFF) >> 6];
            this.buf[this.pos++] = URL_MAP[in[i + 2] & 0x3F];
        }
        switch (in.length % 3) {
            case 1: {
                this.buf[this.pos++] = URL_MAP[(in[end] & 0xFF) >> 2];
                this.buf[this.pos++] = URL_MAP[(in[end] & 3) << 4];
                this.buf[this.pos++] = 61;
                this.buf[this.pos++] = 61;
                break;
            }
            case 2: {
                this.buf[this.pos++] = URL_MAP[(in[end] & 0xFF) >> 2];
                this.buf[this.pos++] = URL_MAP[(in[end] & 3) << 4 | (in[end + 1] & 0xFF) >> 4];
                this.buf[this.pos++] = URL_MAP[(in[end + 1] & 0xF) << 2];
                this.buf[this.pos++] = 61;
            }
        }
        return this;
    }

    byte[] toByteArray() {
        return this.buf;
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            Buffer.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        Buffer.REPLACEMENT_CHARS[34] = "\\\"";
        Buffer.REPLACEMENT_CHARS[92] = "\\\\";
        Buffer.REPLACEMENT_CHARS[9] = "\\t";
        Buffer.REPLACEMENT_CHARS[8] = "\\b";
        Buffer.REPLACEMENT_CHARS[10] = "\\n";
        Buffer.REPLACEMENT_CHARS[13] = "\\r";
        Buffer.REPLACEMENT_CHARS[12] = "\\f";
        IPV6_SIZE = new ThreadLocal<Buffer>(){

            @Override
            protected Buffer initialValue() {
                return new Buffer(39);
            }
        };
        HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        URL_MAP = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    }

    static interface Writer<T> {
        public int sizeInBytes(T var1);

        public void write(T var1, Buffer var2);
    }
}

