/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import zipkin.Annotation;
import zipkin.Span;

public class ApplyTimestampAndDuration {
    public static Span apply(Span span) {
        if (span.timestamp != null && span.duration != null) {
            return span;
        }
        if (span.annotations.size() < 2) {
            if (span.timestamp != null) {
                return span;
            }
            Long guess = ApplyTimestampAndDuration.guessTimestamp(span);
            if (guess == null) {
                return span;
            }
            return span.toBuilder().timestamp(guess).build();
        }
        Long first = span.annotations.get((int)0).timestamp;
        Long last = span.annotations.get((int)(span.annotations.size() - 1)).timestamp;
        int length = span.annotations.size();
        for (int i = 0; i < length; ++i) {
            Annotation annotation = span.annotations.get(i);
            if (annotation.value.equals("cs")) {
                first = annotation.timestamp;
                continue;
            }
            if (!annotation.value.equals("cr")) continue;
            last = annotation.timestamp;
        }
        long ts = span.timestamp != null ? span.timestamp : first;
        Long dur = span.duration != null ? span.duration : (last.equals(first) ? null : Long.valueOf(last - first));
        return span.toBuilder().timestamp(ts).duration(dur).build();
    }

    public static Long guessTimestamp(Span span) {
        if (span.timestamp != null || span.annotations.isEmpty()) {
            return span.timestamp;
        }
        boolean isRoot = span.parentId == null;
        Long rootServerRecv = null;
        int length = span.annotations.size();
        for (int i = 0; i < length; ++i) {
            Annotation annotation = span.annotations.get(i);
            if (annotation.value.equals("cs")) {
                return annotation.timestamp;
            }
            if (!annotation.value.equals("sr") || !isRoot) continue;
            rootServerRecv = annotation.timestamp;
        }
        return rootServerRecv;
    }

    private ApplyTimestampAndDuration() {
    }
}

